/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.string;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.numeric.MathHelper;
import com.helger.base.string.StringHelper;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class StringCount {
    private static final int[] SIZE_TABLE_INT = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] SIZE_TABLE_LONG = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};

    private StringCount() {
    }

    @Nonnegative
    public static int getCharCount(@Nullable String string, char c) {
        return string == null ? 0 : StringCount.getCharCount(string.toCharArray(), c);
    }

    @Nonnegative
    public static int getCharCount(@Nullable char[] cArray, char c) {
        int n = 0;
        if (cArray != null) {
            for (char c2 : cArray) {
                if (c2 != c) continue;
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getLineCount(@Nullable String string) {
        return StringCount.getLineCount(string, '\n');
    }

    @Nonnegative
    public static int getLineCount(@Nullable String string, char c) {
        return 1 + StringCount.getCharCount(string, c);
    }

    @Nonnegative
    public static int getCharacterCount(int n) {
        int n2 = n < 0 ? 2 : 1;
        int n3 = MathHelper.abs(n);
        int n4 = 0;
        while (n3 > SIZE_TABLE_INT[n4]) {
            ++n4;
        }
        return n2 + n4;
    }

    @Nonnegative
    public static int getCharacterCount(long l) {
        int n = l < 0L ? 2 : 1;
        long l2 = MathHelper.abs(l);
        int n2 = 0;
        while (l2 > SIZE_TABLE_LONG[n2]) {
            ++n2;
        }
        return n + n2;
    }

    @Nonnegative
    public static int getOccurrenceCount(@Nullable String string, @Nullable String string2) {
        int n = 0;
        int n2 = StringHelper.getLength(string);
        int n3 = StringHelper.getLength(string2);
        if (n3 > 0 && n2 >= n3) {
            int n4;
            int n5 = 0;
            do {
                if ((n4 = StringHelper.getIndexOf(string, n5, string2)) == -1) continue;
                ++n;
                n5 = n4 + n3;
            } while (n4 != -1);
        }
        return n;
    }

    @Nonnegative
    public static int getOccurrenceCountIgnoreCase(@Nullable String string, @Nullable String string2, @NonNull Locale locale) {
        return string != null && string2 != null ? StringCount.getOccurrenceCount(string.toLowerCase(locale), string2.toLowerCase(locale)) : 0;
    }

    @Nonnegative
    @DevelopersNote(value="This is the same as getCharCount")
    public static int getOccurrenceCount(@Nullable String string, char c) {
        int n = 0;
        int n2 = StringHelper.getLength(string);
        if (n2 >= 1) {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = StringHelper.getIndexOf(string, n4, c)) == -1) continue;
                ++n;
                n4 = n3 + 1;
            } while (n3 != -1);
        }
        return n;
    }

    @Nonnegative
    public static int getOccurrenceCountIgnoreCase(@Nullable String string, char c, @NonNull Locale locale) {
        return string != null ? StringCount.getOccurrenceCount(string.toLowerCase(locale), Character.toLowerCase(c)) : 0;
    }

    @Nonnegative
    public static int getLeadingWhitespaceCount(@Nullable String string) {
        int n;
        if (string != null) {
            int n2 = string.length();
            for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
        }
        return n;
    }

    @Nonnegative
    public static int getTrailingWhitespaceCount(@Nullable String string) {
        int n = 0;
        if (string != null) {
            for (int i = string.length() - 1; i >= 0 && Character.isWhitespace(string.charAt(i)); --i) {
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getLeadingCharCount(@Nullable String string, char c) {
        int n;
        if (string != null) {
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == c; ++n) {
            }
        }
        return n;
    }

    @Nonnegative
    public static int getTrailingCharCount(@Nullable String string, char c) {
        int n = 0;
        if (string != null) {
            for (int i = string.length() - 1; i >= 0 && string.charAt(i) == c; --i) {
                ++n;
            }
        }
        return n;
    }
}

