/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.string;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;

@Immutable
public class StringHex {
    private StringHex() {
    }

    public static char getHexChar(int n) {
        return Character.forDigit(n, 16);
    }

    public static char getHexCharUpperCase(int n) {
        return Character.toUpperCase(StringHex.getHexChar(n));
    }

    public static @NonNull String getHexEncoded(@NonNull String string, @NonNull Charset charset) {
        ValueEnforcer.notNull(string, "Input");
        ValueEnforcer.notNull(charset, "Charset");
        return StringHex.getHexEncoded(string.getBytes(charset));
    }

    public static @NonNull String getHexEncoded(@NonNull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Input");
        return StringHex.getHexEncoded(byArray, 0, byArray.length);
    }

    public static @NonNull String getHexEncoded(@NonNull byte[] byArray, int n, int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            char c = StringHex.getHexChar((by & 0xF0) >> 4);
            char c2 = StringHex.getHexChar(by & 0xF);
            stringBuilder.append(c).append(c2);
        }
        return stringBuilder.toString();
    }

    @CheckForSigned
    public static int getHexValue(@Nonnegative char c) {
        return Character.digit(c, 16);
    }

    public static int getHexByte(@Nonnegative char c, @Nonnegative char c2) {
        int n = StringHex.getHexValue(c);
        int n2 = StringHex.getHexValue(c2);
        return n < 0 || n2 < 0 ? -1 : n << 4 | n2 & 0xFF;
    }

    @ReturnsMutableCopy
    public static @NonNull byte[] getHexDecoded(@NonNull String string) {
        ValueEnforcer.notNull(string, "Input");
        return StringHex.getHexDecoded(string.toCharArray(), 0, string.length());
    }

    @ReturnsMutableCopy
    public static @NonNull byte[] getHexDecoded(@NonNull char[] cArray) {
        ValueEnforcer.notNull(cArray, "Input");
        return StringHex.getHexDecoded(cArray, 0, cArray.length);
    }

    @ReturnsMutableCopy
    public static @NonNull byte[] getHexDecoded(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        ValueEnforcer.isTrue(n2 % 2 == 0, () -> "Passed chars have no even length: " + n2);
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            char c = cArray[n + i];
            char c2 = cArray[n + i + 1];
            int n4 = StringHex.getHexByte(c, c2);
            if (n4 == -1) {
                throw new IllegalArgumentException("Failed to convert '" + c + "' and '" + c2 + "' to a hex value!");
            }
            byArray[n3++] = (byte)n4;
        }
        return byArray;
    }

    public static @NonNull String getHexString(byte by) {
        return Integer.toString(by & 0xFF, 16);
    }

    public static @NonNull String getHexStringLeadingZero(byte by, int n) {
        return StringHelper.getLeadingZero(StringHex.getHexString(by), n);
    }

    public static @NonNull String getHexStringLeadingZero2(byte by) {
        String string = StringHex.getHexString(by);
        return string.length() >= 2 ? string : "0" + string;
    }

    public static @NonNull String getHexString(int n) {
        return Integer.toString(n, 16);
    }

    public static @NonNull String getHexStringLeadingZero(int n, int n2) {
        if (n < 0) {
            return "-" + StringHelper.getLeadingZero(StringHex.getHexString(-n), n2 - 1);
        }
        return StringHelper.getLeadingZero(StringHex.getHexString(n), n2);
    }

    public static @NonNull String getHexString(long l) {
        return Long.toString(l, 16);
    }

    public static @NonNull String getHexStringLeadingZero(long l, int n) {
        if (l < 0L) {
            return "-" + StringHelper.getLeadingZero(StringHex.getHexString(-l), n - 1);
        }
        return StringHelper.getLeadingZero(StringHex.getHexString(l), n);
    }

    public static @NonNull String getHexString(short s) {
        return Integer.toString(s & 0xFFFF, 16);
    }

    public static @NonNull String getHexStringLeadingZero(short s, int n) {
        return StringHelper.getLeadingZero(StringHex.getHexString(s), n);
    }
}

