/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cache.impl;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.builder.IBuilder;
import com.helger.base.string.StringHelper;
import com.helger.cache.impl.Cache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;

@NotThreadSafe
public class CacheBuilder<KEYTYPE, VALUETYPE>
implements IBuilder<Cache<KEYTYPE, VALUETYPE>> {
    private Function<KEYTYPE, VALUETYPE> m_aValueProvider;
    private int m_nMaxSize = 0;
    private String m_sName;
    private boolean m_bAllowNullValues = false;

    @Nonnull
    public CacheBuilder<KEYTYPE, VALUETYPE> valueProvider(@Nullable Function<KEYTYPE, VALUETYPE> function) {
        this.m_aValueProvider = function;
        return this;
    }

    @Nonnull
    public CacheBuilder<KEYTYPE, VALUETYPE> maxSize(int n) {
        this.m_nMaxSize = n;
        return this;
    }

    @Nonnull
    public CacheBuilder<KEYTYPE, VALUETYPE> name(@Nullable String string) {
        this.m_sName = string;
        return this;
    }

    @Nonnull
    public CacheBuilder<KEYTYPE, VALUETYPE> allowNullValues(boolean bl) {
        this.m_bAllowNullValues = bl;
        return this;
    }

    @Nonnull
    public Cache<KEYTYPE, VALUETYPE> build() {
        if (this.m_aValueProvider == null) {
            throw new IllegalStateException("The mandatory Cache Value Provider is missing");
        }
        if (StringHelper.isEmpty((String)this.m_sName)) {
            throw new IllegalStateException("The mandatory Cache Name is missing");
        }
        return new Cache<KEYTYPE, VALUETYPE>(this.m_aValueProvider, this.m_nMaxSize, this.m_sName, this.m_bAllowNullValues);
    }
}

