/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CommonsConcurrentHashMap<KEYTYPE, VALUETYPE>
extends ConcurrentHashMap<KEYTYPE, VALUETYPE>
implements ICommonsMap<KEYTYPE, VALUETYPE> {
    public CommonsConcurrentHashMap() {
    }

    public CommonsConcurrentHashMap(int n) {
        super(n);
    }

    public CommonsConcurrentHashMap(int n, @Nonnegative float f) {
        super(n, f);
    }

    public CommonsConcurrentHashMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(CollectionHelper.getSize(map));
        if (map != null) {
            this.putAll(map);
        }
    }

    public <COLLTYPE> CommonsConcurrentHashMap(@Nullable Collection<? extends COLLTYPE> collection, @NonNull Function<? super COLLTYPE, ? extends KEYTYPE> function, @NonNull Function<? super COLLTYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(collection));
        this.putAllMapped(collection, function, function2);
    }

    public <SRCKEYTYPE, SRCVALUETYPE> CommonsConcurrentHashMap(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @NonNull Function<? super SRCKEYTYPE, ? extends KEYTYPE> function, @NonNull Function<? super SRCVALUETYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(map));
        this.putAllMapped(map, function, function2);
    }

    @Override
    @ReturnsMutableCopy
    public <K, V> @NonNull CommonsConcurrentHashMap<K, V> createInstance() {
        return new CommonsConcurrentHashMap<KEYTYPE, VALUETYPE>();
    }

    @ReturnsMutableCopy
    public @NonNull CommonsConcurrentHashMap<KEYTYPE, VALUETYPE> getClone() {
        return new CommonsConcurrentHashMap<KEYTYPE, VALUETYPE>(this);
    }
}

