/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSortedSet;
import com.helger.collection.commons.MapEntry;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsSortedMap<KEYTYPE, VALUETYPE>
extends SortedMap<KEYTYPE, VALUETYPE>,
ICommonsMap<KEYTYPE, VALUETYPE> {
    @Override
    @ReturnsMutableCopy
    default public <K, V> @NonNull ICommonsSortedMap<K, V> createInstance() {
        return new CommonsTreeMap();
    }

    @Override
    @ReturnsMutableCopy
    default public @NonNull ICommonsSortedSet<KEYTYPE> copyOfKeySet() {
        return new CommonsTreeSet(this.keySet());
    }

    @Override
    @ReturnsMutableCopy
    default public @NonNull ICommonsSortedSet<KEYTYPE> copyOfKeySet(@Nullable Predicate<? super KEYTYPE> predicate) {
        if (predicate == null) {
            return this.copyOfKeySet();
        }
        CommonsTreeSet commonsTreeSet = new CommonsTreeSet();
        CollectionFind.findAll(this.keySet(), predicate, commonsTreeSet::add);
        return commonsTreeSet;
    }

    @Override
    @ReturnsMutableCopy
    default public @NonNull ICommonsSortedSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        CommonsTreeSet<Map.Entry<KEYTYPE, VALUETYPE>> commonsTreeSet = new CommonsTreeSet<Map.Entry<KEYTYPE, VALUETYPE>>();
        for (Map.Entry entry : this.entrySet()) {
            commonsTreeSet.add(new MapEntry(entry));
        }
        return commonsTreeSet;
    }

    @Override
    default public @Nullable KEYTYPE getFirstKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : this.firstKey());
    }

    @Override
    default public @Nullable VALUETYPE getFirstValue(@Nullable VALUETYPE VALUETYPE) {
        Object var2_2 = this.getFirstKey(null);
        return (VALUETYPE)(var2_2 == null ? VALUETYPE : this.get(var2_2));
    }

    default public @Nullable KEYTYPE getLastKey() {
        return this.getLastKey(null);
    }

    default public @Nullable KEYTYPE getLastKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : this.lastKey());
    }

    default public @Nullable VALUETYPE getLastValue() {
        return this.getLastValue(null);
    }

    default public @Nullable VALUETYPE getLastValue(@Nullable VALUETYPE VALUETYPE) {
        Object var2_2 = this.getLastKey(null);
        return (VALUETYPE)(var2_2 == null ? VALUETYPE : this.get(var2_2));
    }

    @Override
    @CodingStyleguideUnaware
    default public @NonNull SortedMap<KEYTYPE, VALUETYPE> getAsUnmodifiable() {
        return Collections.unmodifiableSortedMap(this);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSortedMap<KEYTYPE, VALUETYPE> getClone();
}

