/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.list;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class SafeArrayList<ELEMENTTYPE>
extends CommonsArrayList<ELEMENTTYPE> {
    @MustImplementEqualsAndHashcode
    private final transient Supplier<? extends ELEMENTTYPE> m_aFactory;

    public SafeArrayList() {
        this(() -> null);
    }

    public SafeArrayList(@NonNull Supplier<? extends ELEMENTTYPE> supplier) {
        this.m_aFactory = (Supplier)ValueEnforcer.notNull(supplier, (String)"Factory");
    }

    public @NonNull Supplier<? extends ELEMENTTYPE> getFactory() {
        return this.m_aFactory;
    }

    private void _ensureSize(@Nonnegative int n) {
        int n2 = n - this.size() + 1;
        for (int i = 0; i < n2; ++i) {
            this.add(this.m_aFactory.get());
        }
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int n) {
        this._ensureSize(n);
        return (ELEMENTTYPE)super.get(n);
    }

    public @Nullable ELEMENTTYPE computeIfAbsent(@Nonnegative int n, @NonNull Supplier<? extends ELEMENTTYPE> supplier) {
        this._ensureSize(n);
        Object object = super.get(n);
        if (object == null) {
            object = supplier.get();
            super.set(n, object);
        }
        return (ELEMENTTYPE)object;
    }

    @Override
    public ELEMENTTYPE set(@Nonnegative int n, @NonNull ELEMENTTYPE ELEMENTTYPE) {
        this._ensureSize(n);
        return super.set(n, ELEMENTTYPE);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SafeArrayList safeArrayList = (SafeArrayList)object;
        return this.m_aFactory.equals(safeArrayList.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("factory", this.m_aFactory).getToString();
    }
}

