/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cache;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.cache.IMutableCache;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.map.SoftHashMap;
import com.helger.commons.collection.map.SoftLinkedHashMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.statistics.IMutableStatisticsHandlerCache;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.wrapper.Wrapper;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MappedCache<KEYTYPE, KEYSTORETYPE, VALUETYPE>
implements IMutableCache<KEYTYPE, VALUETYPE> {
    public static final String STATISTICS_PREFIX = "cache:";
    public static final int NO_MAX_SIZE = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedCache.class);
    private final IMutableStatisticsHandlerCache m_aStatsCacheAccess;
    private final IMutableStatisticsHandlerCounter m_aStatsCountRemove;
    private final IMutableStatisticsHandlerCounter m_aStatsCountClear;
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final Function<KEYTYPE, KEYSTORETYPE> m_aCacheKeyProvider;
    private final Function<KEYTYPE, VALUETYPE> m_aValueProvider;
    private final int m_nMaxSize;
    private final String m_sName;
    private final boolean m_bAllowNullValues;
    @GuardedBy(value="m_aRWLock")
    private ICommonsMap<KEYSTORETYPE, Wrapper<VALUETYPE>> m_aCache;

    public MappedCache(@Nonnull Function<KEYTYPE, KEYSTORETYPE> function, @Nonnull Function<KEYTYPE, VALUETYPE> function2, int n, @Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notNull(function, "CacheKeyProvider");
        ValueEnforcer.notNull(function2, "ValueProvider");
        ValueEnforcer.notEmpty(string, "CacheName");
        this.m_aStatsCacheAccess = StatisticsManager.getCacheHandler(STATISTICS_PREFIX + string + "$access");
        this.m_aStatsCountRemove = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$remove");
        this.m_aStatsCountClear = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$clear");
        this.m_aCacheKeyProvider = function;
        this.m_aValueProvider = function2;
        this.m_nMaxSize = n;
        this.m_sName = string;
        this.m_bAllowNullValues = bl;
    }

    @Nonnull
    protected final Function<KEYTYPE, KEYSTORETYPE> getCacheKeyProvider() {
        return this.m_aCacheKeyProvider;
    }

    @Nonnull
    protected final Function<KEYTYPE, VALUETYPE> getValueProvider() {
        return this.m_aValueProvider;
    }

    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    public final boolean hasMaxSize() {
        return this.m_nMaxSize > 0;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    public final boolean isAllowNullValues() {
        return this.m_bAllowNullValues;
    }

    @Nonnull
    @ReturnsMutableCopy
    @OverrideOnDemand
    @CodingStyleguideUnaware
    protected ICommonsMap<KEYSTORETYPE, Wrapper<VALUETYPE>> createCache() {
        return this.hasMaxSize() ? new SoftLinkedHashMap(this.m_nMaxSize) : new SoftHashMap();
    }

    @Nonnull
    @Nonempty
    private String _getCacheLogText() {
        String string = "Cache '" + this.m_sName + "'";
        if (this.hasMaxSize()) {
            string = string + " with max size of " + this.m_nMaxSize;
        }
        return string + ": ";
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void putInCacheNotLocked(@Nonnull KEYSTORETYPE KEYSTORETYPE, @Nonnull Wrapper<VALUETYPE> wrapper) {
        ValueEnforcer.notNull(KEYSTORETYPE, "CacheKey");
        ValueEnforcer.notNull(wrapper, "CacheValue");
        if (this.m_aCache == null) {
            this.m_aCache = this.createCache();
            if (this.m_aCache == null) {
                throw new IllegalStateException(this._getCacheLogText() + "Failed to create internal Map!");
            }
        }
        this.m_aCache.put(KEYSTORETYPE, wrapper);
    }

    @Nonnull
    private KEYSTORETYPE _getCacheKeyNonnull(KEYTYPE KEYTYPE) {
        KEYSTORETYPE KEYSTORETYPE = this.m_aCacheKeyProvider.apply(KEYTYPE);
        if (KEYSTORETYPE == null) {
            throw new IllegalStateException(this._getCacheLogText() + "The created cache key of '" + String.valueOf(KEYTYPE) + "' is null.");
        }
        return KEYSTORETYPE;
    }

    @Nonnull
    private Wrapper<VALUETYPE> _getCacheValue(KEYTYPE KEYTYPE, VALUETYPE VALUETYPE) {
        if (VALUETYPE == null) {
            if (!this.m_bAllowNullValues) {
                throw new IllegalStateException(this._getCacheLogText() + "The created cache value of key '" + String.valueOf(KEYTYPE) + "' is null. null values are not allowed in this cache.");
            }
            return new Wrapper();
        }
        return new Wrapper<VALUETYPE>(VALUETYPE);
    }

    @IsLocked(value=ELockType.WRITE)
    protected final void putInCache(KEYTYPE KEYTYPE, VALUETYPE VALUETYPE) {
        KEYSTORETYPE KEYSTORETYPE = this._getCacheKeyNonnull(KEYTYPE);
        Wrapper<VALUETYPE> wrapper = this._getCacheValue(KEYTYPE, VALUETYPE);
        this.m_aRWLock.writeLocked(() -> this.putInCacheNotLocked(KEYSTORETYPE, wrapper));
    }

    @Nullable
    @MustBeLocked(value=ELockType.READ)
    protected final Wrapper<VALUETYPE> getFromCacheNoStatsNotLocked(@Nullable KEYSTORETYPE KEYSTORETYPE) {
        return this.m_aCache == null ? null : (Wrapper)this.m_aCache.get(KEYSTORETYPE);
    }

    @Nullable
    @IsLocked(value=ELockType.READ)
    protected final Wrapper<VALUETYPE> getFromCacheNoStats(@Nullable KEYSTORETYPE KEYSTORETYPE) {
        if (KEYSTORETYPE == null) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> this.getFromCacheNoStatsNotLocked(KEYSTORETYPE));
    }

    public final boolean isInCache(KEYTYPE KEYTYPE) {
        KEYSTORETYPE KEYSTORETYPE = this.m_aCacheKeyProvider.apply(KEYTYPE);
        return this.getFromCacheNoStats(KEYSTORETYPE) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VALUETYPE getFromCache(KEYTYPE KEYTYPE) {
        KEYSTORETYPE KEYSTORETYPE = this._getCacheKeyNonnull(KEYTYPE);
        Wrapper<VALUETYPE> wrapper = this.getFromCacheNoStats(KEYSTORETYPE);
        if (wrapper == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                wrapper = this.getFromCacheNoStatsNotLocked(KEYSTORETYPE);
                if (wrapper == null) {
                    VALUETYPE VALUETYPE = this.m_aValueProvider.apply(KEYTYPE);
                    wrapper = this._getCacheValue(KEYTYPE, VALUETYPE);
                    this.putInCacheNotLocked(KEYSTORETYPE, wrapper);
                    this.m_aStatsCacheAccess.cacheMiss();
                }
                this.m_aStatsCacheAccess.cacheHit();
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        } else {
            this.m_aStatsCacheAccess.cacheHit();
        }
        return wrapper.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange removeFromCache(KEYTYPE KEYTYPE) {
        KEYSTORETYPE KEYSTORETYPE = this._getCacheKeyNonnull(KEYTYPE);
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aCache == null || this.m_aCache.remove(KEYSTORETYPE) == null) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.m_aStatsCountRemove.increment();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this._getCacheLogText() + "Cache key '" + String.valueOf(KEYTYPE) + "' was removed.");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange clearCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aCache == null || this.m_aCache.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_aCache.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.m_aStatsCountClear.increment();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this._getCacheLogText() + "Cache was cleared");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(() -> CollectionHelper.getSize(this.m_aCache));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> CollectionHelper.isEmpty(this.m_aCache));
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> CollectionHelper.isNotEmpty(this.m_aCache));
    }

    public String toString() {
        return new ToStringGenerator(this).append("CacheKeyProvider", this.m_aCacheKeyProvider).append("ValueProvider", this.m_aValueProvider).append("MaxSize", this.m_nMaxSize).append("Name", this.m_sName).append("AllowNullValues", this.m_bAllowNullValues).append("Cache", this.m_aCache).getToString();
    }
}

