/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.text.TextVariableHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.config.IConfig;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.value.ConfiguredValue;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.config.value.IConfigurationValueProviderWithPriorityCallback;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
implements IConfig {
    public static final boolean DEFAULT_REPLACE_VARIABLES = true;
    public static final boolean DEFAULT_USE_VARIABLE_DEFAULT_VALUES = true;
    public static final UnaryOperator<String> DEFAULT_UNRESOLVED_VARIABLE_PROVIDER = string -> "unresolved-var(" + string + ")";
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    private final IConfigurationValueProvider m_aValueProvider;
    private BiConsumer<String, ConfiguredValue> m_aKeyFoundConsumer;
    private Consumer<String> m_aKeyNotFoundConsumer;
    private boolean m_bReplaceVariables = true;
    private boolean m_bUseVariableDefaultValues = true;
    private UnaryOperator<String> m_aUnresolvedVariableProvider = DEFAULT_UNRESOLVED_VARIABLE_PROVIDER;

    public Config(@NonNull IConfigurationValueProvider iConfigurationValueProvider) {
        ValueEnforcer.notNull((Object)iConfigurationValueProvider, (String)"ValueProvider");
        this.m_aValueProvider = iConfigurationValueProvider;
    }

    public final @NonNull IConfigurationValueProvider getConfigurationValueProvider() {
        return this.m_aValueProvider;
    }

    public final @Nullable BiConsumer<String, ConfiguredValue> getFoundKeyConsumer() {
        return this.m_aKeyFoundConsumer;
    }

    public final @Nullable Config setFoundKeyConsumer(@Nullable BiConsumer<String, ConfiguredValue> biConsumer) {
        this.m_aKeyFoundConsumer = biConsumer;
        return this;
    }

    public final @Nullable Consumer<String> getKeyNotFoundConsumer() {
        return this.m_aKeyNotFoundConsumer;
    }

    public final @Nullable Config setKeyNotFoundConsumer(@Nullable Consumer<String> consumer) {
        this.m_aKeyNotFoundConsumer = consumer;
        return this;
    }

    public final boolean isReplaceVariables() {
        return this.m_bReplaceVariables;
    }

    public final @NonNull Config setReplaceVariables(boolean bl) {
        this.m_bReplaceVariables = bl;
        return this;
    }

    public final boolean isUseVariableDefaultValues() {
        return this.m_bUseVariableDefaultValues;
    }

    public final @NonNull Config setUseVariableDefaultValues(boolean bl) {
        this.m_bUseVariableDefaultValues = bl;
        return this;
    }

    public final @NonNull UnaryOperator<String> getUnresolvedVariableProvider() {
        return this.m_aUnresolvedVariableProvider;
    }

    public final @NonNull Config setUnresolvedVariableProvider(@NonNull UnaryOperator<String> unaryOperator) {
        ValueEnforcer.notNull(unaryOperator, (String)"UnresolvedVariableProvider");
        this.m_aUnresolvedVariableProvider = unaryOperator;
        return this;
    }

    @Override
    public @Nullable ConfiguredValue getConfiguredValue(@Nullable String string) {
        ConfiguredValue configuredValue = StringHelper.isEmpty((String)string) ? null : this.m_aValueProvider.getConfigurationValue(string);
        if (configuredValue != null) {
            if (this.m_aKeyFoundConsumer != null) {
                this.m_aKeyFoundConsumer.accept(string, configuredValue);
            }
        } else if (this.m_aKeyNotFoundConsumer != null) {
            this.m_aKeyNotFoundConsumer.accept(string);
        }
        return configuredValue;
    }

    @Nonempty
    private @NonNull String _getWithVariablesReplacedRecursive(@Nonempty @NonNull String string, @NonNull ICommonsOrderedSet<String> iCommonsOrderedSet) {
        UnaryOperator unaryOperator = string2 -> {
            String string3;
            String string4;
            String string5;
            if (this.m_bUseVariableDefaultValues) {
                int n = string2.indexOf(58);
                string5 = n < 0 ? string2 : string2.substring(0, n);
                string4 = n < 0 ? null : string2.substring(n + 1);
            } else {
                string5 = string2;
                string4 = null;
            }
            if (!iCommonsOrderedSet.add((Object)string5)) {
                throw new IllegalStateException("Found a variable cyclic dependency: " + StringImplode.imploder().source((Collection)iCommonsOrderedSet, string -> "\"" + string + "\"").separator(" -> ").build() + " -> \"" + string5 + "\"");
            }
            ConfiguredValue configuredValue = this.getConfiguredValue(string5);
            if (configuredValue == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to resolve configuration variable '" + string5 + "'");
                }
                if (string4 == null) return (String)this.m_aUnresolvedVariableProvider.apply(string5);
                string3 = string4;
            } else {
                string3 = configuredValue.getValue();
            }
            String string6 = string3;
            if (StringHelper.isNotEmpty((String)string6)) {
                string3 = this._getWithVariablesReplacedRecursive(string3, iCommonsOrderedSet);
            }
            iCommonsOrderedSet.remove((Object)string5);
            return string3;
        };
        return TextVariableHelper.getWithReplacedVariables((String)string, (UnaryOperator)unaryOperator);
    }

    public @Nullable String getValue(@Nullable String string) {
        String string2;
        ConfiguredValue configuredValue = this.getConfiguredValue(string);
        if (configuredValue == null) {
            return null;
        }
        String string3 = string2 = configuredValue.getValue();
        if (this.m_bReplaceVariables && StringHelper.isNotEmpty((String)string3)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Resolving variables in configuration value '" + string2 + "'");
            }
            try {
                string2 = this._getWithVariablesReplacedRecursive(string2, (ICommonsOrderedSet<String>)new CommonsLinkedHashSet());
            }
            catch (IllegalStateException illegalStateException) {
                LOGGER.error("Failed to replace variables in configuration value '" + string2 + "': " + illegalStateException.getMessage());
            }
        }
        return string2;
    }

    private static void _forEachConfigurationValueProviderRecursive(@NonNull IConfigurationValueProvider iConfigurationValueProvider2, int n2, @NonNull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        if (iConfigurationValueProvider2 instanceof MultiConfigurationValueProvider) {
            MultiConfigurationValueProvider multiConfigurationValueProvider = (MultiConfigurationValueProvider)iConfigurationValueProvider2;
            multiConfigurationValueProvider.forEachConfigurationValueProvider((iConfigurationValueProvider, n) -> Config._forEachConfigurationValueProviderRecursive(iConfigurationValueProvider, n, iConfigurationValueProviderWithPriorityCallback));
        } else {
            int n3 = n2;
            if (n3 < 0 && iConfigurationValueProvider2 instanceof IConfigurationSource) {
                IConfigurationSource iConfigurationSource = (IConfigurationSource)iConfigurationValueProvider2;
                n3 = iConfigurationSource.getPriority();
            }
            iConfigurationValueProviderWithPriorityCallback.onConfigurationValueProvider(iConfigurationValueProvider2, n3);
        }
    }

    public static void forEachConfigurationValueProviderRecursive(@NonNull IConfigurationValueProvider iConfigurationValueProvider, @NonNull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        Config._forEachConfigurationValueProviderRecursive(iConfigurationValueProvider, -1, iConfigurationValueProviderWithPriorityCallback);
    }

    @Override
    public void forEachConfigurationValueProvider(@NonNull IConfigurationValueProviderWithPriorityCallback iConfigurationValueProviderWithPriorityCallback) {
        ValueEnforcer.notNull((Object)iConfigurationValueProviderWithPriorityCallback, (String)"Callback");
        Config.forEachConfigurationValueProviderRecursive(this.m_aValueProvider, iConfigurationValueProviderWithPriorityCallback);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ValueProvider", (Object)this.m_aValueProvider).append("KeyFoundConsumer", this.m_aKeyFoundConsumer).append("KeyNotFoundConsumer", this.m_aKeyNotFoundConsumer).append("ReplaceVariables", this.m_bReplaceVariables).append("UseVariableDefaultValues", this.m_bUseVariableDefaultValues).append("UnresolvedVariableProvider", this.m_aUnresolvedVariableProvider).getToString();
    }

    public static @NonNull Config create(@NonNull IConfigurationValueProvider iConfigurationValueProvider) {
        return new Config(iConfigurationValueProvider);
    }
}

