/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.resource;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.config.source.AbstractConfigurationSource;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.resource.IConfigurationSourceResource;
import com.helger.io.resource.IReadableResource;
import java.io.File;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractConfigurationSourceResource
extends AbstractConfigurationSource
implements IConfigurationSourceResource {
    public static final EConfigSourceType CONFIG_SOURCE_TYPE = EConfigSourceType.RESOURCE;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurationSourceResource.class);
    private final IReadableResource m_aRes;

    protected AbstractConfigurationSourceResource(int n, @NonNull IReadableResource iReadableResource) {
        super(CONFIG_SOURCE_TYPE, n);
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_aRes = iReadableResource;
        File file = iReadableResource.getAsFile();
        if (file != null) {
            if (file.isFile()) {
                if (!file.canRead()) {
                    LOGGER.warn("The configuration file '" + file.getAbsolutePath() + "' exists, but is not readable");
                }
            } else if (file.isDirectory()) {
                LOGGER.warn("The configuration file '" + file.getAbsolutePath() + "' exists, but is a directory");
            }
        }
    }

    @Override
    public final @NonNull IReadableResource getResource() {
        return this.m_aRes;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractConfigurationSourceResource abstractConfigurationSourceResource = (AbstractConfigurationSourceResource)object;
        return EqualsHelper.equals((Object)this.m_aRes, (Object)abstractConfigurationSourceResource.m_aRes);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aRes).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Resource", (Object)this.m_aRes).getToString();
    }
}

