/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.helper;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalQuery;
import org.jspecify.annotations.NonNull;

public class PDTMask<T extends Temporal> {
    private final String m_sPattern;
    private final TemporalQuery<T> m_aQuery;

    protected PDTMask(@Nonempty @NonNull String string, @NonNull TemporalQuery<T> temporalQuery) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Pattern");
        ValueEnforcer.notNull(temporalQuery, (String)"Query");
        this.m_sPattern = string;
        this.m_aQuery = temporalQuery;
    }

    @Nonempty
    public @NonNull String getPattern() {
        return this.m_sPattern;
    }

    public @NonNull TemporalQuery<T> getQuery() {
        return this.m_aQuery;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Pattern", (Object)this.m_sPattern).append("Query", this.m_aQuery).getToString();
    }

    public static @NonNull PDTMask<ZonedDateTime> zonedDateTime(@Nonempty @NonNull String string) {
        return new PDTMask<ZonedDateTime>(string, ZonedDateTime::from);
    }

    public static @NonNull PDTMask<OffsetDateTime> offsetDateTime(@Nonempty @NonNull String string) {
        return new PDTMask<OffsetDateTime>(string, OffsetDateTime::from);
    }

    public static @NonNull PDTMask<XMLOffsetDateTime> xmlOffsetDateTime(@Nonempty @NonNull String string) {
        return new PDTMask<XMLOffsetDateTime>(string, XMLOffsetDateTime::from);
    }

    public static @NonNull PDTMask<LocalDateTime> localDateTime(@Nonempty @NonNull String string) {
        return new PDTMask<LocalDateTime>(string, LocalDateTime::from);
    }

    public static @NonNull PDTMask<OffsetDate> offsetDate(@Nonempty @NonNull String string) {
        return new PDTMask<OffsetDate>(string, OffsetDate::from);
    }

    public static @NonNull PDTMask<XMLOffsetDate> xmlOffsetDate(@Nonempty @NonNull String string) {
        return new PDTMask<XMLOffsetDate>(string, XMLOffsetDate::from);
    }

    public static @NonNull PDTMask<LocalDate> localDate(@Nonempty @NonNull String string) {
        return new PDTMask<LocalDate>(string, LocalDate::from);
    }

    public static @NonNull PDTMask<YearMonth> yearMonth(@Nonempty @NonNull String string) {
        return new PDTMask<YearMonth>(string, YearMonth::from);
    }

    public static @NonNull PDTMask<Year> year(@Nonempty @NonNull String string) {
        return new PDTMask<Year>(string, Year::from);
    }
}

