/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringReplace;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.IErrorTextProvider;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class ErrorTextProvider
implements IErrorTextProvider,
ICloneable<ErrorTextProvider> {
    public static final char PLACEHOLDER = '$';
    public static final String PLACEHOLDER_STR = Character.toString('$');
    public static final IErrorTextProvider DEFAULT = new ErrorTextProvider().addItem(EField.ERROR_DATETIME, "[$]").addItem(EField.ERROR_LEVEL, "[$]").addItem(EField.ERROR_ID, "[$]").addItem(EField.ERROR_FIELD_NAME, "in [$]").addItem(EField.ERROR_LOCATION, "@ $").addItem(EField.ERROR_TEXT, "$").addItem(EField.ERROR_LINKED_EXCEPTION_CLASS, "($:").addItem(EField.ERROR_LINKED_EXCEPTION_MESSAGE, "$)").setFieldSeparator(" ");
    private final ICommonsList<IFormattableItem> m_aItems;
    private String m_sFieldSep = " ";

    public ErrorTextProvider() {
        this.m_aItems = new CommonsArrayList();
    }

    public ErrorTextProvider(@NonNull ErrorTextProvider errorTextProvider) {
        this.m_aItems = (ICommonsList)errorTextProvider.m_aItems.getClone();
        this.m_sFieldSep = errorTextProvider.m_sFieldSep;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<IFormattableItem> getAllItems() {
        return (ICommonsList)this.m_aItems.getClone();
    }

    public @NonNull ErrorTextProvider addItem(@NonNull EField eField, @Nonempty @NonNull String string) {
        return this.addItem(new FormattableItem(eField, string));
    }

    public @NonNull ErrorTextProvider addItem(@NonNull IFormattableItem iFormattableItem) {
        ValueEnforcer.notNull((Object)iFormattableItem, (String)"Item");
        this.m_aItems.add((Object)iFormattableItem);
        return this;
    }

    public @NonNull String getFieldSeparator() {
        return this.m_sFieldSep;
    }

    public @NonNull ErrorTextProvider setFieldSeparator(@NonNull String string) {
        this.m_sFieldSep = (String)ValueEnforcer.notNull((Object)string, (String)"FieldSep");
        return this;
    }

    @Override
    public @NonNull String getErrorText(@NonNull IError iError, @NonNull Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        block15: for (IFormattableItem iFormattableItem : this.m_aItems) {
            switch (iFormattableItem.getField().ordinal()) {
                case 0: {
                    stringBuilder.append(iFormattableItem.getUnformattedText());
                    continue block15;
                }
                case 1: {
                    if (!iError.hasErrorDateTime()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorDateTime().toString()));
                    continue block15;
                }
                case 2: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)iError.getErrorLevel().getID()));
                    continue block15;
                }
                case 3: {
                    if (!iError.hasErrorID()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorID()));
                    continue block15;
                }
                case 4: {
                    if (!iError.hasErrorFieldName()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorFieldName()));
                    continue block15;
                }
                case 5: {
                    Object object = iError.getErrorLocation();
                    if (!object.isAnyInformationPresent()) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object.getAsString()));
                    continue block15;
                }
                case 6: {
                    Object object = iError.getErrorText(locale);
                    if (!StringHelper.isNotEmpty((String)object)) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)object));
                    continue block15;
                }
                case 7: {
                    Object object = iError.getLinkedException();
                    if (object == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object.getClass().getName()));
                    continue block15;
                }
                case 8: {
                    Object object = iError.getLinkedException();
                    if (object == null) continue block15;
                    Object object2 = StringHelper.getNotNull((String)((Throwable)object).getMessage(), (String)"");
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)object2));
                    continue block15;
                }
                case 9: {
                    Object object = iError.getLinkedException();
                    if (object == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(StackTraceHelper.getStackAsString((Throwable)object)));
                    continue block15;
                }
                case 10: {
                    Object object = iError.getLinkedException();
                    Object object2 = object != null ? ((Throwable)object).getCause() : null;
                    if (object2 == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object2.getClass().getName()));
                    continue block15;
                }
                case 11: {
                    Object object = iError.getLinkedException();
                    Object object2 = object != null ? ((Throwable)object).getCause() : null;
                    if (object2 == null) continue block15;
                    String string = StringHelper.getNotNull((String)((Throwable)object2).getMessage());
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(string));
                    continue block15;
                }
                case 12: {
                    Object object = iError.getLinkedException();
                    Object object2 = object != null ? ((Throwable)object).getCause() : null;
                    if (object2 == null) continue block15;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(StackTraceHelper.getStackAsString((Throwable)object2)));
                    continue block15;
                }
            }
            throw new IllegalStateException("Unsupported error field " + String.valueOf((Object)iFormattableItem.getField()));
        }
        return stringBuilder.toString();
    }

    @ReturnsMutableCopy
    public @NonNull ErrorTextProvider getClone() {
        return new ErrorTextProvider(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Items", this.m_aItems).append("FieldSeparator", (Object)this.m_sFieldSep).getToString();
    }

    @Immutable
    public static class FormattableItem
    implements IFormattableItem {
        private final EField m_eField;
        private final String m_sText;

        public FormattableItem(@NonNull EField eField, @Nonempty @NonNull String string) {
            this.m_eField = (EField)((Object)ValueEnforcer.notNull((Object)((Object)eField), (String)"Field"));
            this.m_sText = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
            if (eField.isPlaceholderRequired()) {
                ValueEnforcer.isTrue((boolean)this.m_sText.contains(PLACEHOLDER_STR), () -> "Text '" + string + "' is missing placeholder '$'");
            }
        }

        @Override
        public final @NonNull EField getField() {
            return this.m_eField;
        }

        @Override
        @Nonempty
        public @NonNull String getUnformattedText() {
            return this.m_sText;
        }

        @Override
        public @NonNull String getFormattedText(@NonNull String string) {
            return StringReplace.replaceAll((String)this.m_sText, (String)PLACEHOLDER_STR, (CharSequence)string);
        }

        public String toString() {
            return new ToStringGenerator((Object)this).append("Field", (Enum)this.m_eField).append("Text", (Object)this.m_sText).getToString();
        }
    }

    public static enum EField implements IHasID<String>
    {
        CONSTANT("const"),
        ERROR_DATETIME("datetime"),
        ERROR_LEVEL("level"),
        ERROR_ID("id"),
        ERROR_FIELD_NAME("fieldname"),
        ERROR_LOCATION("location"),
        ERROR_TEXT("text"),
        ERROR_LINKED_EXCEPTION_CLASS("%lec"),
        ERROR_LINKED_EXCEPTION_MESSAGE("%lem"),
        ERROR_LINKED_EXCEPTION_STACK_TRACE("%lest"),
        ERROR_LINKED_EXCEPTION_CAUSE_CLASS("%lecc"),
        ERROR_LINKED_EXCEPTION_CAUSE_MESSAGE("%lecm"),
        ERROR_LINKED_EXCEPTION_CAUSE_STACK_TRACE("%lecst");

        private final String m_sID;

        private EField(String string2) {
            this.m_sID = string2;
        }

        @Nonempty
        public @NonNull String getID() {
            return this.m_sID;
        }

        public boolean isPlaceholderRequired() {
            return this != CONSTANT;
        }

        public static @Nullable EField getFromIDOrNull(@Nullable String string) {
            return (EField)EnumHelper.getFromIDOrNull(EField.class, (Object)string);
        }
    }

    public static interface IFormattableItem {
        public @NonNull EField getField();

        public @NonNull String getUnformattedText();

        public @NonNull String getFormattedText(@NonNull String var1);
    }
}

