/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.annotation.Nonempty;
import com.helger.base.name.IHasName;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public interface ICSPDirective
extends IHasName {
    @Nonnull
    @Nonempty
    public String getName();

    @Nullable
    public String getValue();

    default public boolean hasValue() {
        return StringHelper.isNotEmpty((String)this.getValue());
    }

    @Nonnull
    @Nonempty
    default public String getAsString() {
        return StringHelper.getConcatenatedOnDemand((String)this.getName(), (char)' ', (String)this.getValue());
    }

    @Nullable
    default public String getAsStringIfHasValue() {
        String string = this.getValue();
        if (StringHelper.isNotEmpty((String)string)) {
            return this.getName() + " " + string;
        }
        return null;
    }
}

