/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.channel;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.mock.exception.IMockException;
import com.helger.base.state.ESuccess;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ChannelHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelHelper.class);
    private static final boolean USE_COPY_V1 = true;
    private static final ChannelHelper INSTANCE = new ChannelHelper();

    private ChannelHelper() {
    }

    @Nonnegative
    public static long channelCopy(@Nonnull @WillNotClose ReadableByteChannel readableByteChannel, @Nonnull @WillNotClose WritableByteChannel writableByteChannel) throws IOException {
        ValueEnforcer.notNull((Object)readableByteChannel, (String)"SourceChannel");
        ValueEnforcer.isTrue((boolean)readableByteChannel.isOpen(), (String)"SourceChannel is not open!");
        ValueEnforcer.notNull((Object)writableByteChannel, (String)"DestinationChannel");
        ValueEnforcer.isTrue((boolean)writableByteChannel.isOpen(), (String)"DestinationChannel is not open!");
        long l = ChannelHelper._channelCopy1(readableByteChannel, writableByteChannel);
        return l;
    }

    @Nonnegative
    private static long _channelCopy1(@Nonnull @WillNotClose ReadableByteChannel readableByteChannel, @Nonnull @WillNotClose WritableByteChannel writableByteChannel) throws IOException {
        long l = 0L;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            l += (long)writableByteChannel.write(byteBuffer);
            byteBuffer.compact();
        }
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            l += (long)writableByteChannel.write(byteBuffer);
        }
        return l;
    }

    private static long _channelCopy2(@Nonnull @WillNotClose ReadableByteChannel readableByteChannel, @Nonnull @WillNotClose WritableByteChannel writableByteChannel) throws IOException {
        long l = 0L;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                l += (long)writableByteChannel.write(byteBuffer);
            }
            byteBuffer.clear();
        }
        return l;
    }

    @Nonnull
    public static ESuccess close(@Nullable Channel channel) {
        if (channel != null && channel.isOpen()) {
            return StreamHelper.close((AutoCloseable)channel);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess release(@Nullable FileLock fileLock) {
        if (fileLock != null) {
            try {
                fileLock.release();
                return ESuccess.SUCCESS;
            }
            catch (IOException iOException) {
                LOGGER.error("Failed to release object " + String.valueOf(fileLock), (Throwable)(iOException instanceof IMockException ? null : iOException));
            }
        }
        return ESuccess.FAILURE;
    }
}

