/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.inmemory;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.inmemory.IMemoryReadableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.net.URL;

public abstract class AbstractMemoryReadableResource
implements IMemoryReadableResource {
    private final String m_sResourceID;
    private String m_sPath = "";

    protected AbstractMemoryReadableResource(@Nonnull @Nonempty String string) {
        this.m_sResourceID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ResourceID");
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getResourceID() {
        return this.m_sResourceID;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_sPath;
    }

    public void setPath(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Path");
        this.m_sPath = string;
    }

    @Override
    @Nullable
    public URL getAsURL() {
        return null;
    }

    @Override
    @Nullable
    public File getAsFile() {
        return null;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    @Nonnull
    public IReadableResource getReadableCloneForPath(@Nonnull String string) {
        throw new UnsupportedOperationException("Cannot clone in-memory resource '" + this.m_sResourceID + "' for path '" + string + "'");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ResourceID", (Object)this.m_sResourceID).append("Path", (Object)this.m_sPath).getToString();
    }
}

