/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.locale;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.jspecify.annotations.NonNull;

@Immutable
public final class LocaleFormatter {
    private static final LocaleFormatter INSTANCE = new LocaleFormatter();

    private LocaleFormatter() {
    }

    public static @NonNull String getFormatted(double d, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getNumberInstance(locale).format(d);
    }

    public static @NonNull String getFormatted(int n, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getIntegerInstance(locale).format(n);
    }

    public static @NonNull String getFormatted(long l, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getIntegerInstance(locale).format(l);
    }

    public static @NonNull String getFormatted(@NonNull BigInteger bigInteger, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)bigInteger, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getIntegerInstance(locale).format(bigInteger);
    }

    public static @NonNull String getFormatted(@NonNull BigDecimal bigDecimal, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getInstance(locale).format(bigDecimal);
    }

    public static @NonNull String getFormatted(@NonNull BigDecimal bigDecimal, @Nonnegative int n, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(bigDecimal);
    }

    public static @NonNull String getFormattedWithAllFractionDigits(@NonNull BigDecimal bigDecimal, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(bigDecimal.scale());
        return numberFormat.format(bigDecimal);
    }

    public static @NonNull String getFormattedPercent(double d, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getPercentInstance(locale).format(d);
    }

    public static @NonNull String getFormattedPercent(double d, @Nonnegative int n, @NonNull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        NumberFormat numberFormat = NumberFormat.getPercentInstance(locale);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }
}

