/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.callback.CallbackList;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.hierarchy.IHasChildrenRecursive;
import com.helger.collection.hierarchy.IHasChildrenSorted;
import com.helger.collection.hierarchy.IHasParent;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.EMicroEvent;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroEventTarget;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroCDATA;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroEntityReference;
import com.helger.xml.microdom.MicroProcessingInstruction;
import com.helger.xml.microdom.MicroText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Predicate;

public interface IMicroNode
extends ICloneable<IMicroNode>,
IHasChildrenSorted<IMicroNode>,
IHasChildrenRecursive<IMicroNode>,
IHasParent<IMicroNode> {
    @Nonnull
    @Nonempty
    public String getNodeName();

    default public String getNodeValue() {
        return "";
    }

    @Nullable
    public ICommonsList<IMicroNode> getAllChildren();

    default public boolean containsAnyChild(@Nonnull Predicate<? super IMicroNode> predicate) {
        ValueEnforcer.notNull(predicate, (String)"Filter");
        if (this.hasNoChildren()) {
            return false;
        }
        return this.getAllChildren().containsAny(predicate);
    }

    @Nullable
    public IMicroNode getFirstChild();

    @Nullable
    public IMicroNode getLastChild();

    @Nullable
    default public ICommonsList<IMicroNode> getAllChildrenRecursive() {
        if (this.hasNoChildren()) {
            return null;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.forAllChildrenRecursive(arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    @Nullable
    public IMicroNode getPreviousSibling();

    @Nullable
    public IMicroNode getNextSibling();

    public boolean hasParent();

    @Nullable
    public IMicroNode getParent();

    @Nonnull
    public IMicroNode detachFromParent();

    @Nullable
    public IMicroElement findParentElement(@Nonnull Predicate<? super IMicroElement> var1);

    @Nullable
    default public IMicroElement getParentElementWithName(@Nullable String string) {
        return this.findParentElement(iMicroElement -> iMicroElement.getTagName().equals(string));
    }

    @Nullable
    default public IMicroElement getParentElementWithName(@Nullable String string, @Nullable String string2) {
        return this.findParentElement(iMicroElement -> iMicroElement.hasNamespaceURI(string) && iMicroElement.getTagName().equals(string2));
    }

    @Deprecated
    @Nullable
    default public <NODETYPE extends IMicroNode> NODETYPE appendChild(@Nullable NODETYPE NODETYPE) {
        return this.addChild(NODETYPE);
    }

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE addChild(@Nullable NODETYPE var1);

    @Deprecated
    default public void appendChildren(IMicroNode ... iMicroNodeArray) {
        this.addChildren(iMicroNodeArray);
    }

    default public void addChildren(IMicroNode ... iMicroNodeArray) {
        if (iMicroNodeArray != null) {
            for (IMicroNode iMicroNode : iMicroNodeArray) {
                this.addChild(iMicroNode);
            }
        }
    }

    @Deprecated
    default public void appendChildren(@Nullable Iterable<? extends IMicroNode> iterable) {
        this.addChildren(iterable);
    }

    default public void addChildren(@Nullable Iterable<? extends IMicroNode> iterable) {
        if (iterable != null) {
            for (IMicroNode iMicroNode : iterable) {
                this.addChild(iMicroNode);
            }
        }
    }

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertBefore(@Nullable NODETYPE var1, @Nonnull IMicroNode var2);

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertAfter(@Nullable NODETYPE var1, @Nonnull IMicroNode var2);

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertAtIndex(@Nonnegative int var1, @Nullable NODETYPE var2);

    @Deprecated
    @Nonnull
    default public IMicroText appendText(boolean bl) {
        return this.addText(bl);
    }

    @Nonnull
    default public IMicroText addText(boolean bl) {
        return this.addText(Boolean.toString(bl));
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendText(int n) {
        return this.addText(n);
    }

    @Nonnull
    default public IMicroText addText(int n) {
        return this.addText(Integer.toString(n));
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendText(long l) {
        return this.addText(l);
    }

    @Nonnull
    default public IMicroText addText(long l) {
        return this.addText(Long.toString(l));
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendText(@Nullable CharSequence charSequence) {
        return this.addText(charSequence);
    }

    @Nonnull
    default public IMicroText addText(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroText(charSequence, false));
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendText(@Nonnull char[] cArray) {
        return this.addText(cArray);
    }

    @Nonnull
    default public IMicroText addText(@Nonnull char[] cArray) {
        return this.addText(cArray, 0, cArray.length);
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addText(cArray, n, n2);
    }

    @Nonnull
    default public IMicroText addText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroText(cArray, n, n2, false));
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendTextWithConversion(@Nullable Object object) {
        return this.addTextWithConversion(object);
    }

    @Nonnull
    default public IMicroText addTextWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convert((Object)object, String.class);
        return this.addText(string);
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendIgnorableWhitespaceText(@Nullable CharSequence charSequence) {
        return this.addIgnorableWhitespaceText(charSequence);
    }

    @Nonnull
    default public IMicroText addIgnorableWhitespaceText(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroText(charSequence, true));
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendIgnorableWhitespaceText(@Nonnull char[] cArray) {
        return this.addIgnorableWhitespaceText(cArray);
    }

    @Nonnull
    default public IMicroText addIgnorableWhitespaceText(@Nonnull char[] cArray) {
        return this.addIgnorableWhitespaceText(cArray, 0, cArray.length);
    }

    @Deprecated
    @Nonnull
    default public IMicroText appendIgnorableWhitespaceText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addIgnorableWhitespaceText(cArray, n, n2);
    }

    @Nonnull
    default public IMicroText addIgnorableWhitespaceText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroText(cArray, n, n2, true));
    }

    @Deprecated
    @Nonnull
    default public IMicroCDATA appendCDATA(@Nullable CharSequence charSequence) {
        return this.addCDATA(charSequence);
    }

    @Nonnull
    default public IMicroCDATA addCDATA(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroCDATA(charSequence));
    }

    @Deprecated
    @Nonnull
    default public IMicroCDATA appendCDATA(@Nonnull char[] cArray) {
        return this.addCDATA(cArray);
    }

    @Nonnull
    default public IMicroCDATA addCDATA(@Nonnull char[] cArray) {
        return this.addCDATA(cArray, 0, cArray.length);
    }

    @Deprecated
    @Nonnull
    default public IMicroCDATA appendCDATA(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addCDATA(cArray, n, n2);
    }

    @Nonnull
    default public IMicroCDATA addCDATA(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroCDATA(cArray, n, n2));
    }

    @Deprecated
    @Nonnull
    default public IMicroCDATA appendCDATAWithConversion(@Nullable Object object) {
        return this.addCDATAWithConversion(object);
    }

    @Nonnull
    default public IMicroCDATA addCDATAWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convert((Object)object, String.class);
        return this.addCDATA(string);
    }

    @Deprecated
    @Nonnull
    default public IMicroComment appendComment(@Nullable CharSequence charSequence) {
        return this.addComment(charSequence);
    }

    @Nonnull
    default public IMicroComment addComment(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroComment(charSequence));
    }

    @Deprecated
    @Nonnull
    default public IMicroComment appendComment(@Nonnull char[] cArray) {
        return this.addComment(cArray);
    }

    @Nonnull
    default public IMicroComment addComment(@Nonnull char[] cArray) {
        return this.addComment(cArray, 0, cArray.length);
    }

    @Deprecated
    @Nonnull
    default public IMicroComment appendComment(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addComment(cArray, n, n2);
    }

    @Nonnull
    default public IMicroComment addComment(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroComment(cArray, n, n2));
    }

    @Deprecated
    @Nonnull
    default public IMicroComment appendCommentWithConversion(@Nullable Object object) {
        return this.addCommentWithConversion(object);
    }

    @Nonnull
    default public IMicroComment addCommentWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convert((Object)object, String.class);
        return this.addComment(string);
    }

    @Deprecated
    @Nonnull
    default public IMicroEntityReference appendEntityReference(@Nonnull String string) {
        return this.addEntityReference(string);
    }

    @Nonnull
    default public IMicroEntityReference addEntityReference(@Nonnull String string) {
        return this.addChild(new MicroEntityReference(string));
    }

    @Deprecated
    @Nonnull
    default public IMicroElement appendElement(@Nonnull @Nonempty String string) {
        return this.addElement(string);
    }

    @Nonnull
    default public IMicroElement addElement(@Nonnull @Nonempty String string) {
        return this.addElementNS(null, string);
    }

    @Deprecated
    @Nonnull
    default public IMicroElement appendElement(@Nullable String string, @Nonnull @Nonempty String string2) {
        return this.addElementNS(string, string2);
    }

    @Nonnull
    default public IMicroElement addElementNS(@Nullable String string, @Nonnull @Nonempty String string2) {
        return this.addChild(new MicroElement(string, string2));
    }

    @Deprecated
    @Nonnull
    default public IMicroProcessingInstruction appendProcessingInstruction(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.addProcessingInstruction(string, string2);
    }

    @Nonnull
    default public IMicroProcessingInstruction addProcessingInstruction(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.addChild(new MicroProcessingInstruction(string, string2));
    }

    @Deprecated
    @Nonnull
    default public IMicroContainer appendContainer() {
        return this.addContainer();
    }

    @Nonnull
    default public IMicroContainer addContainer() {
        return this.addChild(new MicroContainer());
    }

    @Nonnull
    public EChange removeChild(@Nonnull IMicroNode var1);

    @Nonnull
    public EChange removeChildAtIndex(@Nonnegative int var1);

    @Nonnull
    public EChange removeAllChildren();

    @Nonnull
    default public EChange replaceChild(@Nonnull IMicroNode iMicroNode, @Nonnull IMicroNode iMicroNode2) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"OldChild");
        ValueEnforcer.notNull((Object)iMicroNode2, (String)"NewChild");
        if (iMicroNode.equals(iMicroNode2)) {
            return EChange.UNCHANGED;
        }
        this.insertBefore(iMicroNode2, iMicroNode);
        this.removeChild(iMicroNode);
        return EChange.CHANGED;
    }

    @Nonnull
    public EMicroNodeType getType();

    public boolean isDocument();

    public boolean isDocumentType();

    public boolean isText();

    public boolean isCDATA();

    public boolean isComment();

    public boolean isEntityReference();

    public boolean isElement();

    public boolean isProcessingInstruction();

    public boolean isContainer();

    @Nonnull
    public EChange registerEventTarget(@Nonnull EMicroEvent var1, @Nonnull IMicroEventTarget var2);

    @Nonnull
    public EChange unregisterEventTarget(@Nonnull EMicroEvent var1, @Nonnull IMicroEventTarget var2);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EMicroEvent, CallbackList<IMicroEventTarget>> getAllEventTargets();

    @Nonnull
    @ReturnsMutableCopy
    public CallbackList<IMicroEventTarget> getAllEventTargets(@Nullable EMicroEvent var1);

    public boolean isEqualContent(@Nullable IMicroNode var1);
}

