/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.ICallback;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.sax.LoggingSAXErrorHandler;
import com.helger.xml.serialize.read.XMLLoggingExceptionCallback;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import javax.xml.validation.Schema;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

@ThreadSafe
public final class DOMReaderDefaultSettings {
    public static final boolean DEFAULT_REQUIRES_NEW_XML_PARSER_EXPLICITLY = false;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultNamespaceAware = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultValidating = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultIgnoringElementContentWhitespace = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultExpandEntityReferences = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultIgnoringComments = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultCoalescing = true;
    @GuardedBy(value="RW_LOCK")
    private static Schema s_aDefaultSchema;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultXIncludeAware;
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<EXMLParserProperty, Object> DEFAULT_PROPS;
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<EXMLParserFeature, Boolean> DEFAULT_FEATURES;
    @GuardedBy(value="RW_LOCK")
    private static EntityResolver s_aDefaultEntityResolver;
    @GuardedBy(value="RW_LOCK")
    private static ErrorHandler s_aDefaultErrorHandler;
    private static final CallbackList<IExceptionCallback<Throwable>> DEFAULT_EXCEPTION_CALLBACKS;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultRequiresNewXMLParserExplicitly;
    private static final DOMReaderDefaultSettings INSTANCE;

    private DOMReaderDefaultSettings() {
    }

    public static boolean isNamespaceAware() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultNamespaceAware);
    }

    public static void setNamespaceAware(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultNamespaceAware = bl;
        });
    }

    public static boolean isValidating() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultValidating);
    }

    public static void setValidating(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultValidating = bl;
        });
    }

    public static boolean isIgnoringElementContentWhitespace() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultIgnoringElementContentWhitespace);
    }

    public static void setIgnoringElementContentWhitespace(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultIgnoringElementContentWhitespace = bl;
        });
    }

    public static boolean isExpandEntityReferences() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultExpandEntityReferences);
    }

    public static void setExpandEntityReferences(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultExpandEntityReferences = bl;
        });
    }

    public static boolean isIgnoringComments() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultIgnoringComments);
    }

    public static void setIgnoringComments(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultIgnoringComments = bl;
        });
    }

    public static boolean isCoalescing() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultCoalescing);
    }

    public static void setCoalescing(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultCoalescing = bl;
        });
    }

    @Nullable
    public static Schema getSchema() {
        return (Schema)RW_LOCK.readLockedGet(() -> s_aDefaultSchema);
    }

    public static void setSchema(@Nullable Schema schema) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultSchema = schema;
        });
    }

    public static boolean isXIncludeAware() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultXIncludeAware);
    }

    public static void setXIncludeAware(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultXIncludeAware = bl;
        });
    }

    public static boolean hasAnyProperties() {
        return RW_LOCK.readLockedBoolean(() -> DEFAULT_PROPS.isNotEmpty());
    }

    @Nullable
    public static Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return null;
        }
        return RW_LOCK.readLockedGet(() -> DEFAULT_PROPS.get((Object)eXMLParserProperty));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserProperty, Object> getAllPropertyValues() {
        return (ICommonsMap)RW_LOCK.readLockedGet(() -> DEFAULT_PROPS.getClone());
    }

    public static void setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserProperty), (String)"Property");
        RW_LOCK.writeLocked(() -> {
            if (object != null) {
                DEFAULT_PROPS.put((Object)eXMLParserProperty, object);
            } else {
                DEFAULT_PROPS.remove((Object)eXMLParserProperty);
            }
        });
    }

    public static void setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null) {
            RW_LOCK.writeLocked(() -> DEFAULT_PROPS.putAll(map));
        }
    }

    @Nonnull
    public static EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_PROPS.removeObject((Object)eXMLParserProperty));
    }

    @Nonnull
    public static EChange removeAllPropertyValues() {
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_PROPS.removeAll());
    }

    public static boolean hasAnyFeature() {
        return RW_LOCK.readLockedBoolean(() -> DEFAULT_FEATURES.isNotEmpty());
    }

    @Nullable
    public static Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return null;
        }
        return (Boolean)RW_LOCK.readLockedGet(() -> (Boolean)DEFAULT_FEATURES.get((Object)eXMLParserFeature));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return (ICommonsMap)RW_LOCK.readLockedGet(() -> DEFAULT_FEATURES.getClone());
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        RW_LOCK.writeLocked(() -> DEFAULT_FEATURES.put((Object)eXMLParserFeature, (Object)bl));
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        RW_LOCK.writeLocked(() -> {
            if (bl == null) {
                DEFAULT_FEATURES.remove((Object)eXMLParserFeature);
            } else {
                DEFAULT_FEATURES.put((Object)eXMLParserFeature, (Object)bl);
            }
        });
    }

    public static void setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null) {
            RW_LOCK.writeLocked(() -> DEFAULT_FEATURES.putAll(map));
        }
    }

    @Nonnull
    public static EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_FEATURES.removeObject((Object)eXMLParserFeature));
    }

    @Nonnull
    public static EChange removeAllFeatures() {
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_FEATURES.removeAll());
    }

    public static boolean requiresNewXMLParser() {
        return RW_LOCK.readLockedBoolean(() -> {
            if (s_bDefaultRequiresNewXMLParserExplicitly) {
                return true;
            }
            if (!s_bDefaultNamespaceAware || s_bDefaultValidating || s_bDefaultIgnoringElementContentWhitespace || !s_bDefaultExpandEntityReferences || !s_bDefaultIgnoringComments || !s_bDefaultCoalescing || s_aDefaultSchema != null || s_bDefaultXIncludeAware || DEFAULT_PROPS.isNotEmpty() || DEFAULT_FEATURES.isNotEmpty()) {
                return true;
            }
            return s_aDefaultEntityResolver != null;
        });
    }

    @Nullable
    public static EntityResolver getEntityResolver() {
        return (EntityResolver)RW_LOCK.readLockedGet(() -> s_aDefaultEntityResolver);
    }

    public static void setEntityResolver(@Nullable EntityResolver entityResolver) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultEntityResolver = entityResolver;
        });
    }

    @Nullable
    public static ErrorHandler getErrorHandler() {
        return (ErrorHandler)RW_LOCK.readLockedGet(() -> s_aDefaultErrorHandler);
    }

    public static void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultErrorHandler = errorHandler;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IExceptionCallback<Throwable>> exceptionCallbacks() {
        return DEFAULT_EXCEPTION_CALLBACKS;
    }

    public static boolean isRequiresNewXMLParserExplicitly() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultRequiresNewXMLParserExplicitly);
    }

    public static void setRequiresNewXMLParserExplicitly(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultRequiresNewXMLParserExplicitly = bl;
        });
    }

    static {
        s_bDefaultXIncludeAware = false;
        DEFAULT_PROPS = new CommonsEnumMap(EXMLParserProperty.class);
        DEFAULT_FEATURES = new CommonsEnumMap(EXMLParserFeature.class);
        s_aDefaultErrorHandler = new LoggingSAXErrorHandler();
        DEFAULT_EXCEPTION_CALLBACKS = new CallbackList();
        DEFAULT_EXCEPTION_CALLBACKS.add((ICallback)new XMLLoggingExceptionCallback());
        s_bDefaultRequiresNewXMLParserExplicitly = false;
        INSTANCE = new DOMReaderDefaultSettings();
    }
}

