/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.MustImplementComparable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.compare.CompareHelper;
import com.helger.base.compare.IComparable;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import javax.xml.namespace.QName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
@MustImplementComparable
public interface IMicroQName
extends IComparable<IMicroQName> {
    public @Nullable String getNamespaceURI();

    default public boolean hasNamespaceURI() {
        return StringHelper.isNotEmpty((String)this.getNamespaceURI());
    }

    default public boolean hasNoNamespaceURI() {
        return StringHelper.isEmpty((String)this.getNamespaceURI());
    }

    default public boolean hasNamespaceURI(@Nullable String string) {
        return EqualsHelper.equals((Object)string, (Object)this.getNamespaceURI());
    }

    @Nonempty
    public @NonNull String getName();

    default public int compareTo(@NonNull IMicroQName iMicroQName) {
        int n = CompareHelper.compare((Comparable)((Object)this.getNamespaceURI()), (Comparable)((Object)iMicroQName.getNamespaceURI()));
        if (n == 0) {
            n = this.getName().compareTo(iMicroQName.getName());
        }
        return n;
    }

    default public @NonNull QName getAsXMLQName() {
        return new QName(this.getNamespaceURI(), this.getName());
    }

    default public @NonNull QName getAsXMLQName(@NonNull String string) {
        return new QName(this.getNamespaceURI(), this.getName(), string);
    }
}

