/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.xml.XMLHelper;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroCDATA;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.MicroDocumentType;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroEntityReference;
import com.helger.xml.microdom.MicroProcessingInstruction;
import com.helger.xml.microdom.MicroText;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

@Immutable
public final class MicroHelper {
    private static final MicroHelper INSTANCE = new MicroHelper();

    private MicroHelper() {
    }

    public static @NonNull IMicroNode append(@NonNull IMicroNode iMicroNode, @Nullable Object object) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"SrcNode");
        if (object != null) {
            if (object instanceof IMicroNode) {
                IMicroNode iMicroNode2 = (IMicroNode)object;
                iMicroNode.addChild(iMicroNode2);
            } else if (object instanceof String) {
                String string = (String)object;
                iMicroNode.addText(string);
            } else if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    MicroHelper.append(iMicroNode, t);
                }
            } else if (ArrayHelper.isArray((Object)object)) {
                for (Object object2 : (Object[])object) {
                    MicroHelper.append(iMicroNode, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to an IMicroNode (type=" + object.getClass().getName() + ".");
            }
        }
        return iMicroNode;
    }

    public static @NonNull String getPath(@Nullable IMicroNode iMicroNode, @NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Separator");
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode2 = iMicroNode; iMicroNode2 != null; iMicroNode2 = iMicroNode2.getParent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, string);
            }
            stringBuilder.insert(0, iMicroNode2.getNodeName());
        }
        return stringBuilder.toString();
    }

    public static @Nullable String getDocumentRootElementTagName(@Nullable IMicroDocument iMicroDocument) {
        IMicroElement iMicroElement;
        if (iMicroDocument != null && (iMicroElement = iMicroDocument.getDocumentElement()) != null) {
            return iMicroElement.getTagName();
        }
        return null;
    }

    public static @NonNull IMicroNode convertToMicroNode(@NonNull Node node2) {
        ValueEnforcer.notNull((Object)node2, (String)"Node");
        short s = node2.getNodeType();
        AbstractMicroNode abstractMicroNode = switch (s) {
            case 9 -> new MicroDocument();
            case 10 -> {
                DocumentType var3_3 = (DocumentType)node2;
                yield new MicroDocumentType(var3_3.getName(), var3_3.getPublicId(), var3_3.getSystemId());
            }
            case 1 -> {
                Element var3_4 = (Element)node2;
                String var4_6 = var3_4.getNamespaceURI();
                MicroElement var5_7 = var4_6 != null ? new MicroElement(var4_6, var3_4.getLocalName()) : new MicroElement(var3_4.getTagName());
                XMLHelper.forAllAttributes(var3_4, attr -> {
                    String string = attr.getNamespaceURI();
                    if (string != null) {
                        if (!"http://www.w3.org/2000/xmlns/".equals(string)) {
                            var5_7.setAttributeNS(string, attr.getLocalName(), attr.getValue());
                        }
                    } else {
                        var5_7.setAttribute(attr.getName(), attr.getValue());
                    }
                });
                yield var5_7;
            }
            case 4 -> new MicroCDATA(node2.getNodeValue());
            case 3 -> new MicroText(node2.getNodeValue());
            case 8 -> new MicroComment(node2.getNodeValue());
            case 5 -> new MicroEntityReference(node2.getNodeValue());
            case 7 -> {
                ProcessingInstruction var3_5 = (ProcessingInstruction)node2;
                yield new MicroProcessingInstruction(var3_5.getTarget(), var3_5.getData());
            }
            case 2 -> throw new IllegalArgumentException("Unknown/unsupported node type: ATTRIBUTE_NODE");
            case 6 -> throw new IllegalArgumentException("Unknown/unsupported node type: ENTITY_NODE");
            case 11 -> throw new IllegalArgumentException("Unknown/unsupported node type: DOCUMENT_FRAGMENT_NODE");
            case 12 -> throw new IllegalArgumentException("Unknown/unsupported node type: NOTATION_NODE");
            default -> throw new IllegalArgumentException("Unknown/unsupported node type: " + s);
        };
        XMLHelper.iterateChildren(node2, node -> abstractMicroNode.addChild(MicroHelper.convertToMicroNode(node)));
        return abstractMicroNode;
    }

    public static @Nullable String getChildTextContent(@NonNull IMicroElement iMicroElement, @NonNull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    public static @Nullable String getChildTextContentTrimmed(@NonNull IMicroElement iMicroElement, @NonNull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    public static <DSTTYPE> @Nullable DSTTYPE getChildTextContentWithConversion(@NonNull IMicroElement iMicroElement, @NonNull String string, @NonNull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    public static @Nullable String getChildTextContent(@NonNull IMicroElement iMicroElement, @NonNull String string, @NonNull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    public static @Nullable String getChildTextContentTrimmed(@NonNull IMicroElement iMicroElement, @NonNull String string, @NonNull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    public static <DSTTYPE> @Nullable DSTTYPE getChildTextContentWithConversion(@NonNull IMicroElement iMicroElement, @NonNull String string, @NonNull String string2, @NonNull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    @ReturnsMutableCopy
    public static @NonNull IMicroContainer getAllChildrenAsContainer(@NonNull IMicroNode iMicroNode2) {
        MicroContainer microContainer = new MicroContainer();
        iMicroNode2.forAllChildren(iMicroNode -> microContainer.addChild((IMicroNode)iMicroNode.getClone()));
        return microContainer;
    }

    @ReturnsMutableCopy
    public static @NonNull IMicroContainer getAllOriginalChildrenAsContainer(@NonNull IMicroNode iMicroNode2) {
        MicroContainer microContainer = new MicroContainer();
        iMicroNode2.forAllChildren(iMicroNode -> microContainer.addChild(iMicroNode.detachFromParent()));
        return microContainer;
    }
}

