/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.xpath.MapBasedXPathVariableResolver;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class MapBasedXPathVariableResolverQName
implements XPathVariableResolver,
ICloneable<MapBasedXPathVariableResolverQName> {
    private final ICommonsMap<QName, Object> m_aMap;

    public MapBasedXPathVariableResolverQName() {
        this((Map)null);
    }

    public MapBasedXPathVariableResolverQName(@Nullable Map<QName, ?> map) {
        this.m_aMap = new CommonsHashMap(map);
    }

    public MapBasedXPathVariableResolverQName(@NonNull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolverQName, (String)"Other");
        this.m_aMap = (ICommonsMap)mapBasedXPathVariableResolverQName.m_aMap.getClone();
    }

    public @NonNull EChange addUniqueVariable(@NonNull QName qName, @NonNull Object object) {
        ValueEnforcer.notNull((Object)qName, (String)"Name");
        ValueEnforcer.notNull((Object)object, (String)"Value");
        if (this.m_aMap.containsKey((Object)qName)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)qName, object);
        return EChange.CHANGED;
    }

    public @NonNull EChange addAllFrom(@NonNull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName, boolean bl) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolverQName, (String)"Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolverQName.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put((Object)((QName)entry.getKey()), entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    public @NonNull EChange addAllFrom(@NonNull MapBasedXPathVariableResolver mapBasedXPathVariableResolver, boolean bl) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolver, (String)"Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolver.getAllVariables().entrySet()) {
            QName qName = new QName((String)entry.getKey());
            if (!bl && this.m_aMap.containsKey((Object)qName)) continue;
            this.m_aMap.put((Object)qName, entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    public @NonNull EChange removeVariable(@Nullable QName qName) {
        if (qName == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aMap.removeObject((Object)qName);
    }

    public @NonNull EChange removeVariables(@Nullable Iterable<? extends QName> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (QName qName : iterable) {
                eChange = eChange.or((IChangeIndicator)this.removeVariable(qName));
            }
        }
        return eChange;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsMap<QName, ?> getAllVariables() {
        return (ICommonsMap)this.m_aMap.getClone();
    }

    @Nonnegative
    public int getVariableCount() {
        return this.m_aMap.size();
    }

    public @NonNull EChange clear() {
        return this.m_aMap.removeAll();
    }

    public void setAllVariables(@Nullable Map<QName, ?> map) {
        this.m_aMap.setAll(map);
    }

    @Override
    public @Nullable Object resolveVariable(@NonNull QName qName) {
        ValueEnforcer.notNull((Object)qName, (String)"VariableName");
        return this.m_aMap.get((Object)qName);
    }

    @ReturnsMutableCopy
    public @NonNull MapBasedXPathVariableResolverQName getClone() {
        return new MapBasedXPathVariableResolverQName(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName = (MapBasedXPathVariableResolverQName)object;
        return EqualsHelper.equals(this.m_aMap, mapBasedXPathVariableResolverQName.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

