/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.coord;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementComparable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diver.api.DVRException;
import com.helger.diver.api.coord.DVRCoordinateException;
import com.helger.diver.api.coord.IDVRCoordinate;
import com.helger.diver.api.settings.DVRValidityHelper;
import com.helger.diver.api.version.DVRPseudoVersionRegistry;
import com.helger.diver.api.version.DVRVersion;
import com.helger.diver.api.version.DVRVersionException;
import com.helger.diver.api.version.IDVRPseudoVersion;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementComparable
@MustImplementEqualsAndHashcode
public final class DVRCoordinate
implements IDVRCoordinate,
Comparable<DVRCoordinate> {
    public static final char PART_SEPARATOR = ':';
    private static final Logger LOGGER = LoggerFactory.getLogger(DVRCoordinate.class);
    private final String m_sGroupID;
    private final String m_sArtifactID;
    private final DVRVersion m_aVersion;
    private final String m_sClassifier;
    private transient int m_nHashCode = 0;

    public DVRCoordinate(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull DVRVersion dVRVersion) {
        this(string, string2, dVRVersion, null);
    }

    public DVRCoordinate(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull DVRVersion dVRVersion, @Nullable String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"GroupID");
        ValueEnforcer.isTrue(() -> DVRValidityHelper.isValidCoordinateGroupID(string), () -> "GroupID '" + string + "' is invalid");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ArtifactID");
        ValueEnforcer.isTrue(() -> DVRValidityHelper.isValidCoordinateArtifactID(string2), () -> "ArtifactID '" + string2 + "' is invalid");
        ValueEnforcer.notNull((Object)dVRVersion, (String)"Version");
        ValueEnforcer.isTrue(() -> DVRValidityHelper.isValidCoordinateVersion(dVRVersion.getAsString()), () -> "Version '" + String.valueOf(dVRVersion) + "' is invalid");
        ValueEnforcer.isTrue(() -> DVRValidityHelper.isValidCoordinateClassifier(string3), () -> "Classifier '" + string3 + "' is invalid");
        this.m_sGroupID = string;
        this.m_sArtifactID = string2;
        this.m_aVersion = dVRVersion;
        this.m_sClassifier = StringHelper.isNotEmpty((String)string3) ? string3 : null;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getGroupID() {
        return this.m_sGroupID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getArtifactID() {
        return this.m_sArtifactID;
    }

    @Override
    @Nonnull
    public DVRVersion getVersionObj() {
        return this.m_aVersion;
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.m_sClassifier;
    }

    @Nonnull
    public DVRCoordinate getWithGroupID(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sGroupID, (Object)string)) {
            return this;
        }
        return new DVRCoordinate(string, this.m_sArtifactID, this.m_aVersion, this.m_sClassifier);
    }

    @Nonnull
    public DVRCoordinate getWithArtifactID(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sArtifactID, (Object)string)) {
            return this;
        }
        return new DVRCoordinate(this.m_sGroupID, string, this.m_aVersion, this.m_sClassifier);
    }

    @Nonnull
    public DVRCoordinate getWithVersion(@Nonnull DVRVersion dVRVersion) {
        if (EqualsHelper.equals((Object)this.m_aVersion, (Object)dVRVersion)) {
            return this;
        }
        return new DVRCoordinate(this.m_sGroupID, this.m_sArtifactID, dVRVersion, this.m_sClassifier);
    }

    @Nonnull
    public DVRCoordinate getWithVersion(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
        return this.getWithVersion(DVRVersion.of(iDVRPseudoVersion));
    }

    @Nonnull
    public DVRCoordinate getWithVersionLatest() {
        return this.getWithVersion(DVRPseudoVersionRegistry.LATEST);
    }

    @Nonnull
    public DVRCoordinate getWithVersionLatestRelease() {
        return this.getWithVersion(DVRPseudoVersionRegistry.LATEST_RELEASE);
    }

    @Nonnull
    public DVRCoordinate getWithClassifier(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sClassifier, (Object)string)) {
            return this;
        }
        return new DVRCoordinate(this.m_sGroupID, this.m_sArtifactID, this.m_aVersion, string);
    }

    @Nonnull
    @Nonempty
    public static String getAsSingleID(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4) {
        StringBuilder stringBuilder = new StringBuilder().append(string).append(':').append(string2).append(':').append(string3);
        if (StringHelper.isNotEmpty((String)string4)) {
            stringBuilder.append(':').append(string4);
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsSingleID() {
        return DVRCoordinate.getAsSingleID(this.m_sGroupID, this.m_sArtifactID, this.getVersionString(), this.m_sClassifier);
    }

    public static int compare(@Nonnull DVRCoordinate dVRCoordinate, @Nonnull DVRCoordinate dVRCoordinate2) {
        int n = dVRCoordinate.m_sGroupID.compareTo(dVRCoordinate2.m_sGroupID);
        if (n == 0 && (n = dVRCoordinate.m_sArtifactID.compareTo(dVRCoordinate2.m_sArtifactID)) == 0 && (n = dVRCoordinate.m_aVersion.compareTo(dVRCoordinate2.m_aVersion)) == 0) {
            n = CompareHelper.compare((Comparable)((Object)dVRCoordinate.m_sClassifier), (Comparable)((Object)dVRCoordinate2.m_sClassifier));
        }
        return n;
    }

    @Override
    public int compareTo(@Nonnull DVRCoordinate dVRCoordinate) {
        return DVRCoordinate.compare(this, dVRCoordinate);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DVRCoordinate dVRCoordinate = (DVRCoordinate)object;
        return this.m_sGroupID.equals(dVRCoordinate.m_sGroupID) && this.m_sArtifactID.equals(dVRCoordinate.m_sArtifactID) && this.m_aVersion.equals(dVRCoordinate.m_aVersion) && EqualsHelper.equals((Object)this.m_sClassifier, (Object)dVRCoordinate.m_sClassifier);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_sGroupID).append((Object)this.m_sArtifactID).append((Object)this.m_aVersion).append((Object)this.m_sClassifier).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("GroupID", (Object)this.m_sGroupID).append("ArtifactID", (Object)this.m_sArtifactID).append("Version", (Object)this.m_aVersion).appendIf("Classifier", (Object)this.m_sClassifier, StringHelper::isNotEmpty).getToString();
    }

    @Nonnull
    public static DVRCoordinate create(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) throws DVRVersionException {
        return DVRCoordinate.create(string, string2, string3, null);
    }

    @Nonnull
    public static DVRCoordinate create(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4) throws DVRVersionException {
        return new DVRCoordinate(string, string2, DVRVersion.parseOrThrow(string3), string4);
    }

    @Nonnull
    public static DVRCoordinate parseOrThrow(@Nullable String string) throws DVRCoordinateException, DVRVersionException {
        List list = StringHelper.getExploded((char)':', (String)string);
        int n = list.size();
        if (n >= 3 && n <= 4) {
            return DVRCoordinate.create((String)list.get(0), (String)list.get(1), (String)list.get(2), n >= 4 ? (String)list.get(3) : null);
        }
        throw new DVRCoordinateException("Invalid DVR Coordinates '" + string + "' provided!");
    }

    @Nullable
    public static DVRCoordinate parseOrNull(@Nullable String string) {
        try {
            return DVRCoordinate.parseOrThrow(string);
        }
        catch (DVRException | RuntimeException exception) {
            LOGGER.warn(exception.getMessage());
            return null;
        }
    }
}

