/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.version;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementComparable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.version.Version;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.diver.api.settings.DVRValidityHelper;
import com.helger.diver.api.version.DVRPseudoVersionRegistry;
import com.helger.diver.api.version.DVRVersionException;
import com.helger.diver.api.version.IDVRPseudoVersion;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementComparable
@MustImplementEqualsAndHashcode
public final class DVRVersion
implements Comparable<DVRVersion> {
    public static final String QUALIFIER_SNAPSHOT = "SNAPSHOT";
    public static final char NUMERIC_VERSION_PART_SEPARATOR = '.';
    public static final char DEFAULT_CLASSIFIER_SEPARATOR = '-';
    private static final Logger LOGGER = LoggerFactory.getLogger(DVRVersion.class);
    private final Version m_aStaticVersion;
    private final IDVRPseudoVersion m_aPseudoVersion;

    private DVRVersion(@Nullable Version version, @Nullable IDVRPseudoVersion iDVRPseudoVersion) {
        ValueEnforcer.isTrue((version != null || iDVRPseudoVersion != null ? 1 : 0) != 0, (String)"Either Static Version or Pseudo Version must be provided");
        ValueEnforcer.isFalse((version != null && iDVRPseudoVersion != null ? 1 : 0) != 0, (String)"Only one of Static Version or Pseudo Version must be provided");
        this.m_aStaticVersion = version;
        this.m_aPseudoVersion = iDVRPseudoVersion;
    }

    public boolean isStaticVersion() {
        return this.m_aStaticVersion != null;
    }

    public static boolean isStaticSnapshotVersion(@Nullable String string) {
        return QUALIFIER_SNAPSHOT.equals(string);
    }

    public static boolean isStaticSnapshotVersion(@Nullable Version version) {
        return version != null && DVRVersion.isStaticSnapshotVersion(version.getQualifier());
    }

    public boolean isStaticSnapshotVersion() {
        return DVRVersion.isStaticSnapshotVersion(this.m_aStaticVersion);
    }

    @Nullable
    public Version getStaticVersion() {
        return this.m_aStaticVersion;
    }

    public boolean isPseudoVersion() {
        return this.m_aPseudoVersion != null;
    }

    @Nullable
    public IDVRPseudoVersion getPseudoVersion() {
        return this.m_aPseudoVersion;
    }

    @Nonnull
    private static String _getAsString(@Nonnull Version version, char c, boolean bl, boolean bl2) {
        Object object = "";
        char c2 = c;
        boolean bl3 = bl;
        if (version.hasQualifier()) {
            object = version.getQualifier();
        }
        if (version.getMicro() > 0 || bl3) {
            if (!((String)object).isEmpty()) {
                object = c2 + (String)object;
            }
            object = version.getMicro() + (String)object;
            c2 = '.';
            bl3 = true;
        }
        if (bl2) {
            bl3 = true;
        }
        if (version.getMinor() > 0 || bl3) {
            if (!((String)object).isEmpty()) {
                object = c2 + (String)object;
            }
            object = version.getMinor() + (String)object;
            c2 = '.';
            bl3 = true;
        }
        if (version.getMajor() > 0 || bl3 || ((String)object).isEmpty()) {
            if (!((String)object).isEmpty()) {
                object = c2 + (String)object;
            }
            object = version.getMajor() + (String)object;
        }
        return object;
    }

    @Nonnull
    public static String getAsString(@Nonnull Version version) {
        return DVRVersion._getAsString(version, '-', false, false);
    }

    @Nonnull
    @Nonempty
    public static String getAsString(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
        return (String)iDVRPseudoVersion.getID();
    }

    @Nonnull
    public String getAsString() {
        if (this.m_aStaticVersion != null) {
            return DVRVersion.getAsString(this.m_aStaticVersion);
        }
        return DVRVersion.getAsString(this.m_aPseudoVersion);
    }

    @Nonnull
    private static Version _getWithoutQualifier(@Nonnull Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro(), null);
    }

    private static int _compareSemantically(@Nonnull Version version, @Nonnull Version version2) {
        if (QUALIFIER_SNAPSHOT.equals(version.getQualifier())) {
            if (QUALIFIER_SNAPSHOT.equals(version2.getQualifier())) {
                return version.compareTo(version2);
            }
            Version version3 = DVRVersion._getWithoutQualifier(version);
            int n = version3.compareTo(version2);
            if (n == 0) {
                return -1;
            }
            return n;
        }
        if (QUALIFIER_SNAPSHOT.equals(version2.getQualifier())) {
            Version version4 = DVRVersion._getWithoutQualifier(version2);
            int n = version.compareTo(version4);
            if (n == 0) {
                return 1;
            }
            return n;
        }
        return version.compareTo(version2);
    }

    private static int _compareWithPseudoVersion(@Nonnull Version version, @Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
        return -iDVRPseudoVersion.compareToVersion(version);
    }

    @Override
    public int compareTo(@Nonnull DVRVersion dVRVersion) {
        if (this.isStaticVersion()) {
            if (dVRVersion.isStaticVersion()) {
                return DVRVersion._compareSemantically(this.m_aStaticVersion, dVRVersion.m_aStaticVersion);
            }
            return DVRVersion._compareWithPseudoVersion(this.m_aStaticVersion, dVRVersion.m_aPseudoVersion);
        }
        if (dVRVersion.isStaticVersion()) {
            return -DVRVersion._compareWithPseudoVersion(dVRVersion.m_aStaticVersion, this.m_aPseudoVersion);
        }
        return this.m_aPseudoVersion.compareToPseudoVersion(dVRVersion.m_aPseudoVersion);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DVRVersion dVRVersion = (DVRVersion)object;
        return EqualsHelper.equals((Object)this.m_aStaticVersion, (Object)dVRVersion.m_aStaticVersion) && EqualsHelper.equals((Object)this.m_aPseudoVersion, (Object)dVRVersion.m_aPseudoVersion);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aStaticVersion).append((Object)this.m_aPseudoVersion).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("StaticVersion", (Object)this.m_aStaticVersion).appendIfNotNull("PseudoVersion", (Object)this.m_aPseudoVersion).getToString();
    }

    @Nonnull
    public static DVRVersion of(@Nonnull Version version) {
        ValueEnforcer.notNull((Object)version, (String)"Version");
        return new DVRVersion(version, null);
    }

    @Nonnull
    public static DVRVersion of(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
        ValueEnforcer.notNull((Object)iDVRPseudoVersion, (String)"PseudoVersion");
        return new DVRVersion(null, iDVRPseudoVersion);
    }

    @Nonnull
    public static DVRVersion latest() {
        return DVRVersion.of(DVRPseudoVersionRegistry.LATEST);
    }

    @Nonnull
    public static DVRVersion latestRelease() {
        return DVRVersion.of(DVRPseudoVersionRegistry.LATEST_RELEASE);
    }

    public static boolean isValidStaticVersion(@Nullable String string2) {
        if (StringHelper.isEmpty((String)string2)) {
            return false;
        }
        if (!DVRValidityHelper.isValidCoordinateVersion(string2)) {
            return false;
        }
        Version version = Version.parse((String)string2);
        if (version == null) {
            return false;
        }
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        for (char c : "-.".toCharArray()) {
            for (boolean bl : new boolean[]{true, false}) {
                for (boolean bl2 : new boolean[]{true, false}) {
                    String string3 = DVRVersion._getAsString(version, c, bl, bl2);
                    if (string2.equals(string3)) {
                        return true;
                    }
                    commonsLinkedHashSet.add((Object)string3);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("'" + string2 + "' is none of " + StringImplode.imploder().source((Collection)commonsLinkedHashSet, string -> "'" + string + "'").separator(" or ").build());
        }
        return false;
    }

    @Nonnull
    public static DVRVersion parseOrThrow(@Nullable String string) throws DVRVersionException {
        if (StringHelper.isEmpty((String)string)) {
            throw new DVRVersionException("DVR Version string must not be empty");
        }
        IDVRPseudoVersion iDVRPseudoVersion = DVRPseudoVersionRegistry.getInstance().getFromIDOrNull(string);
        if (iDVRPseudoVersion != null) {
            return DVRVersion.of(iDVRPseudoVersion);
        }
        if (DVRVersion.isValidStaticVersion(string)) {
            return DVRVersion.of(Version.parse((String)string));
        }
        throw new DVRVersionException("Failed to parse '" + string + "' to a DVR Version");
    }

    @Nullable
    public static DVRVersion parseOrNull(@Nullable String string) {
        try {
            return DVRVersion.parseOrThrow(string);
        }
        catch (DVRVersionException | RuntimeException exception) {
            LOGGER.warn(exception.getMessage());
            return null;
        }
    }

    @Nonnull
    public static Predicate<DVRVersion> getStaticVersionAcceptor(@Nullable Set<String> set, boolean bl) {
        if (CollectionHelper.isEmpty(set)) {
            if (bl) {
                return dVRVersion -> true;
            }
            return dVRVersion -> !dVRVersion.isStaticSnapshotVersion();
        }
        if (bl) {
            return dVRVersion -> !set.contains(dVRVersion.getAsString());
        }
        return dVRVersion -> !dVRVersion.isStaticSnapshotVersion() && !set.contains(dVRVersion.getAsString());
    }
}

