/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.ean;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.masterdata.ean.AbstractUPCEAN;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class GTINValidator {
    private static final GTINValidator INSTANCE = new GTINValidator();

    private GTINValidator() {
    }

    private static boolean _containsValidChecksum(@Nonnull char[] cArray) {
        int n;
        int n2 = AbstractUPCEAN.calcChecksum(cArray, cArray.length - 1);
        return n2 == (n = AbstractUPCEAN.asInt(cArray[cArray.length - 1]));
    }

    private static boolean _isValidGTIN(@Nullable String string, @Nonnegative int n) {
        if (StringHelper.getLength((CharSequence)string) != n) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (AbstractUPCEAN.validateMessage(cArray).isInvalid()) {
            return false;
        }
        return GTINValidator._containsValidChecksum(cArray);
    }

    public static boolean isValidGTIN8(@Nullable String string) {
        return GTINValidator._isValidGTIN(string, 8);
    }

    public static boolean isValidGTIN12(@Nullable String string) {
        return GTINValidator._isValidGTIN(string, 12);
    }

    public static boolean isValidGTIN13(@Nullable String string) {
        return GTINValidator._isValidGTIN(string, 13);
    }

    public static boolean isValidGLN(@Nullable String string) {
        return GTINValidator.isValidGTIN13(string);
    }

    public static boolean isValidGTIN14(@Nullable String string) {
        return GTINValidator._isValidGTIN(string, 14);
    }

    public static boolean isValidSSCC(@Nullable String string) {
        return GTINValidator._isValidGTIN(string, 18);
    }
}

