/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemHelper;
import com.helger.masterdata.person.ESalutation;
import com.helger.masterdata.person.PersonName;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public final class PersonNameMicroTypeConverter
implements IMicroTypeConverter<PersonName> {
    protected static final IMicroQName ATTR_SALUTATION = new MicroQName("salutation");
    protected static final IMicroQName ATTR_PREFIXTITLE = new MicroQName("prefixtitle");
    protected static final IMicroQName ATTR_FIRSTNAME = new MicroQName("firstname");
    protected static final IMicroQName ATTR_MIDDLENAME = new MicroQName("middlename");
    protected static final IMicroQName ATTR_LASTNAME = new MicroQName("lastname");
    protected static final IMicroQName ATTR_SUFFIXTITLE = new MicroQName("suffixtitle");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PersonName personName, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        if (personName.getSalutation() != null) {
            microElement.setAttribute(ATTR_SALUTATION, personName.getSalutationID());
        }
        if (StringHelper.isNotEmpty((String)personName.getPrefixTitle())) {
            microElement.setAttribute(ATTR_PREFIXTITLE, personName.getPrefixTitle());
        }
        if (StringHelper.isNotEmpty((String)personName.getFirstName())) {
            microElement.setAttribute(ATTR_FIRSTNAME, personName.getFirstName());
        }
        if (StringHelper.isNotEmpty((String)personName.getMiddleName())) {
            microElement.setAttribute(ATTR_MIDDLENAME, personName.getMiddleName());
        }
        if (StringHelper.isNotEmpty((String)personName.getLastName())) {
            microElement.setAttribute(ATTR_LASTNAME, personName.getLastName());
        }
        if (StringHelper.isNotEmpty((String)personName.getSuffixTitle())) {
            microElement.setAttribute(ATTR_SUFFIXTITLE, personName.getSuffixTitle());
        }
        return microElement;
    }

    @Nonnull
    public PersonName convertToNative(@Nonnull IMicroElement iMicroElement) {
        Locale locale = SystemHelper.getSystemLocale();
        PersonName personName = new PersonName();
        personName.setSalutation(ESalutation.getFromIDOrNull(iMicroElement.getAttributeValue(ATTR_SALUTATION)));
        personName.setPrefixTitle(iMicroElement.getAttributeValue(ATTR_PREFIXTITLE));
        personName.setFirstName(iMicroElement.getAttributeValue(ATTR_FIRSTNAME), locale);
        personName.setMiddleName(iMicroElement.getAttributeValue(ATTR_MIDDLENAME), locale);
        personName.setLastName(iMicroElement.getAttributeValue(ATTR_LASTNAME), locale);
        personName.setSuffixTitle(iMicroElement.getAttributeValue(ATTR_SUFFIXTITLE));
        return personName;
    }
}

