/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.base.lang.EnumHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EIBANElementType {
    COUNTRY_CODE(""),
    BIC_BANK_CODE("a"),
    NATIONAL_BANK_CODE("b"),
    ACCOUNT_NUMBER("c"),
    CHECK_DIGIT("d"),
    BRANCH_CODE_FRANCE("g"),
    HOLDERS_KENNITALA_ICELAND("i"),
    IBAN_CHECK_DIGITS("k"),
    OWNER_ACCOUNT_NUMBER("n"),
    BRANCH_CODE("s"),
    ACCOUNT_TYPE("t"),
    NATION_CHECK_DIGIT("x");

    private final String m_sField;

    private EIBANElementType(String string2) {
        this.m_sField = string2;
    }

    @Nonnull
    public String getField() {
        return this.m_sField;
    }

    @Nullable
    public static EIBANElementType getElementTypeFromChar(char c) {
        return (EIBANElementType)EnumHelper.findFirst(EIBANElementType.class, eIBANElementType -> eIBANElementType.m_sField.indexOf(c) != -1);
    }
}

