/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy;

import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.type.ITypedObject;
import com.helger.datetime.util.PDTHelper;
import com.helger.tenancy.datetime.IHasCreationInfo;
import com.helger.tenancy.datetime.IHasDeletionInfo;
import com.helger.tenancy.datetime.IHasLastModificationInfo;
import com.helger.typeconvert.collection.IStringMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

public interface IBusinessObject
extends ITypedObject<String>,
IHasCreationInfo,
IHasLastModificationInfo,
IHasDeletionInfo {
    @Nullable
    default public LocalDateTime getLastChangeDateTime() {
        LocalDateTime localDateTime;
        LocalDateTime localDateTime2;
        LocalDateTime localDateTime3 = localDateTime2 = this.getCreationDateTime();
        LocalDateTime localDateTime4 = this.getLastModificationDateTime();
        if (localDateTime4 != null) {
            localDateTime3 = localDateTime3 != null ? PDTHelper.getMax((LocalDateTime)localDateTime3, (LocalDateTime)localDateTime4) : localDateTime4;
        }
        if ((localDateTime = this.getDeletionDateTime()) != null) {
            localDateTime3 = localDateTime3 != null ? PDTHelper.getMax((LocalDateTime)localDateTime3, (LocalDateTime)localDateTime) : localDateTime;
        }
        return localDateTime3;
    }

    default public boolean isLastChangeAfter(@Nonnull LocalDateTime localDateTime) {
        LocalDateTime localDateTime2 = this.getLastChangeDateTime();
        return localDateTime2 != null && localDateTime2.isAfter(localDateTime);
    }

    default public boolean isDeleted() {
        return this.hasDeletionDateTime();
    }

    default public boolean isNotDeleted() {
        return !this.hasDeletionDateTime();
    }

    @Nonnull
    @ReturnsMutableObject
    public IStringMap attrs();
}

