/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smp;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.peppol.smp.ESMPTransportProfileState;
import com.helger.peppol.smp.ISMPTransportProfile;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class SMPTransportProfile
implements ISMPTransportProfile,
ICloneable<SMPTransportProfile> {
    public static final ObjectType OT = new ObjectType("smp.transport.profile");
    public static final ESMPTransportProfileState DEFAULT_STATE = ESMPTransportProfileState.ACTIVE;
    private final String m_sID;
    private String m_sName;
    private ESMPTransportProfileState m_eState;

    static @NonNull ESMPTransportProfileState internalGetDeprecatedState(boolean bl) {
        return bl ? ESMPTransportProfileState.DEPRECATED : ESMPTransportProfileState.ACTIVE;
    }

    public SMPTransportProfile(@NonNull ISMPTransportProfile iSMPTransportProfile) {
        this(iSMPTransportProfile.getID(), iSMPTransportProfile.getName(), iSMPTransportProfile.getState());
    }

    public SMPTransportProfile(@Nonempty @NonNull String string, @Nonempty @NonNull String string2) {
        this(string, string2, DEFAULT_STATE);
    }

    public SMPTransportProfile(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @NonNull ESMPTransportProfileState eSMPTransportProfileState) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.setName(string2);
        this.setState(eSMPTransportProfileState);
    }

    public @NonNull ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonempty
    public @NonNull String getID() {
        return this.m_sID;
    }

    @Override
    @Nonempty
    public @NonNull String getName() {
        return this.m_sName;
    }

    public final @NonNull EChange setName(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Override
    public @NonNull ESMPTransportProfileState getState() {
        return this.m_eState;
    }

    public final @NonNull EChange setState(@NonNull ESMPTransportProfileState eSMPTransportProfileState) {
        ValueEnforcer.notNull((Object)((Object)eSMPTransportProfileState), (String)"State");
        if (eSMPTransportProfileState.equals((Object)this.m_eState)) {
            return EChange.UNCHANGED;
        }
        this.m_eState = eSMPTransportProfileState;
        return EChange.CHANGED;
    }

    public @NonNull SMPTransportProfile getClone() {
        return new SMPTransportProfile(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMPTransportProfile sMPTransportProfile = (SMPTransportProfile)object;
        return this.m_sID.equals(sMPTransportProfile.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("Name", (Object)this.m_sName).append("State", (Enum)this.m_eState).getToString();
    }
}

