/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.eusr.model;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.numeric.BigHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.eusr.model.IEUSRSubsetKey;
import com.helger.peppol.reporting.eusr.model.SubsetKeyDT_EUC;
import com.helger.peppol.reporting.eusr.model.SubsetKeyDT_PR;
import com.helger.peppol.reporting.eusr.model.SubsetKeyDT_PR_EUC;
import com.helger.peppol.reporting.eusr.model.SubsetKeyEUC;
import com.helger.peppol.reporting.jaxb.eusr.v110.EndUserStatisticsReportType;
import com.helger.peppol.reporting.jaxb.eusr.v110.FullSetType;
import com.helger.peppol.reporting.jaxb.eusr.v110.SubsetKeyType;
import com.helger.peppol.reporting.jaxb.eusr.v110.SubsetType;
import java.math.BigInteger;
import java.util.Map;
import org.jspecify.annotations.NonNull;

@Immutable
public class EUSRReportingItemList {
    private EUSRReportingItemList() {
    }

    private static @NonNull SubsetKeyType _createSubsetKey(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3) {
        SubsetKeyType subsetKeyType = new SubsetKeyType();
        subsetKeyType.setMetaSchemeID(string);
        subsetKeyType.setSchemeID(string2);
        subsetKeyType.setValue(string3);
        return subsetKeyType;
    }

    public static void fillReportSubsets(@NonNull Iterable<? extends PeppolReportingItem> iterable, @NonNull EndUserStatisticsReportType endUserStatisticsReportType) {
        SubsetKeyDT_EUC subsetKeyDT_EUC2;
        Object object;
        IEUSRSubsetKey<SubsetKeyDT_PR> iEUSRSubsetKey;
        ValueEnforcer.notNull(iterable, (String)"ReportingItems");
        ValueEnforcer.notNull((Object)endUserStatisticsReportType, (String)"Report");
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        CommonsHashSet commonsHashSet2 = new CommonsHashSet();
        CommonsHashSet commonsHashSet3 = new CommonsHashSet();
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
        CommonsTreeMap commonsTreeMap2 = new CommonsTreeMap();
        CommonsTreeMap commonsTreeMap3 = new CommonsTreeMap();
        CommonsTreeMap commonsTreeMap4 = new CommonsTreeMap();
        for (PeppolReportingItem object2 : iterable) {
            iEUSRSubsetKey = new SubsetKeyDT_PR(object2.getDocTypeIDScheme(), object2.getDocTypeIDValue(), object2.getProcessIDScheme(), object2.getProcessIDValue());
            object = new SubsetKeyEUC(object2.getEndUserCountryCode());
            subsetKeyDT_EUC2 = new SubsetKeyDT_EUC(object2.getDocTypeIDScheme(), object2.getDocTypeIDValue(), object2.getEndUserCountryCode());
            SubsetKeyDT_PR_EUC subsetKeyDT_PR_EUC2 = new SubsetKeyDT_PR_EUC(object2.getDocTypeIDScheme(), object2.getDocTypeIDValue(), object2.getProcessIDScheme(), object2.getProcessIDValue(), object2.getEndUserCountryCode());
            String string = object2.getEndUserID();
            boolean bl = object2.isSending();
            ((EndUserCounter)commonsTreeMap.computeIfAbsent(iEUSRSubsetKey, subsetKeyDT_PR -> new EndUserCounter())).inc(string, bl);
            ((EndUserCounter)commonsTreeMap2.computeIfAbsent(object, subsetKeyEUC -> new EndUserCounter())).inc(string, bl);
            ((EndUserCounter)commonsTreeMap3.computeIfAbsent((Object)subsetKeyDT_EUC2, subsetKeyDT_EUC -> new EndUserCounter())).inc(string, bl);
            ((EndUserCounter)commonsTreeMap4.computeIfAbsent((Object)subsetKeyDT_PR_EUC2, subsetKeyDT_PR_EUC -> new EndUserCounter())).inc(string, bl);
            if (bl) {
                commonsHashSet.add((Object)string);
            } else {
                commonsHashSet2.add((Object)string);
            }
            commonsHashSet3.add((Object)string);
        }
        FullSetType fullSetType = new FullSetType();
        fullSetType.setSendingEndUsers(BigHelper.toBigInteger((int)commonsHashSet.size()));
        fullSetType.setReceivingEndUsers(BigHelper.toBigInteger((int)commonsHashSet2.size()));
        fullSetType.setSendingOrReceivingEndUsers(BigHelper.toBigInteger((int)commonsHashSet3.size()));
        endUserStatisticsReportType.setFullSet(fullSetType);
        for (Map.Entry entry : commonsTreeMap.entrySet()) {
            iEUSRSubsetKey = (SubsetKeyDT_PR)entry.getKey();
            object = (EndUserCounter)entry.getValue();
            subsetKeyDT_EUC2 = new SubsetType();
            subsetKeyDT_EUC2.setType("PerDT-PR");
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("DT", ((SubsetKeyDT_PR)iEUSRSubsetKey).getDocTypeIDScheme(), ((SubsetKeyDT_PR)iEUSRSubsetKey).getDocTypeIDValue()));
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("PR", ((SubsetKeyDT_PR)iEUSRSubsetKey).getProcessIDScheme(), ((SubsetKeyDT_PR)iEUSRSubsetKey).getProcessIDValue()));
            subsetKeyDT_EUC2.setSendingEndUsers(((EndUserCounter)object).getSendingEndUserCount());
            subsetKeyDT_EUC2.setReceivingEndUsers(((EndUserCounter)object).getReceivingEndUserCount());
            subsetKeyDT_EUC2.setSendingOrReceivingEndUsers(((EndUserCounter)object).getSendingOrReceivingEndUserCount());
            endUserStatisticsReportType.addSubset((SubsetType)subsetKeyDT_EUC2);
        }
        for (Map.Entry entry : commonsTreeMap2.entrySet()) {
            iEUSRSubsetKey = (SubsetKeyEUC)entry.getKey();
            object = (EndUserCounter)entry.getValue();
            subsetKeyDT_EUC2 = new SubsetType();
            subsetKeyDT_EUC2.setType("PerEUC");
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("CC", "EndUserCountry", ((SubsetKeyEUC)iEUSRSubsetKey).getEndUserCountryCode()));
            subsetKeyDT_EUC2.setSendingEndUsers(((EndUserCounter)object).getSendingEndUserCount());
            subsetKeyDT_EUC2.setReceivingEndUsers(((EndUserCounter)object).getReceivingEndUserCount());
            subsetKeyDT_EUC2.setSendingOrReceivingEndUsers(((EndUserCounter)object).getSendingOrReceivingEndUserCount());
            endUserStatisticsReportType.addSubset((SubsetType)subsetKeyDT_EUC2);
        }
        for (Map.Entry entry : commonsTreeMap3.entrySet()) {
            iEUSRSubsetKey = (SubsetKeyDT_EUC)entry.getKey();
            object = (EndUserCounter)entry.getValue();
            subsetKeyDT_EUC2 = new SubsetType();
            subsetKeyDT_EUC2.setType("PerDT-EUC");
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("DT", ((SubsetKeyDT_EUC)iEUSRSubsetKey).getDocTypeIDScheme(), ((SubsetKeyDT_EUC)iEUSRSubsetKey).getDocTypeIDValue()));
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("CC", "EndUserCountry", ((SubsetKeyDT_EUC)iEUSRSubsetKey).getEndUserCountryCode()));
            subsetKeyDT_EUC2.setSendingEndUsers(((EndUserCounter)object).getSendingEndUserCount());
            subsetKeyDT_EUC2.setReceivingEndUsers(((EndUserCounter)object).getReceivingEndUserCount());
            subsetKeyDT_EUC2.setSendingOrReceivingEndUsers(((EndUserCounter)object).getSendingOrReceivingEndUserCount());
            endUserStatisticsReportType.addSubset((SubsetType)subsetKeyDT_EUC2);
        }
        for (Map.Entry entry : commonsTreeMap4.entrySet()) {
            iEUSRSubsetKey = (SubsetKeyDT_PR_EUC)entry.getKey();
            object = (EndUserCounter)entry.getValue();
            subsetKeyDT_EUC2 = new SubsetType();
            subsetKeyDT_EUC2.setType("PerDT-PR-EUC");
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("DT", ((SubsetKeyDT_PR_EUC)iEUSRSubsetKey).getDocTypeIDScheme(), ((SubsetKeyDT_PR_EUC)iEUSRSubsetKey).getDocTypeIDValue()));
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("PR", ((SubsetKeyDT_PR_EUC)iEUSRSubsetKey).getProcessIDScheme(), ((SubsetKeyDT_PR_EUC)iEUSRSubsetKey).getProcessIDValue()));
            subsetKeyDT_EUC2.addKey(EUSRReportingItemList._createSubsetKey("CC", "EndUserCountry", ((SubsetKeyDT_PR_EUC)iEUSRSubsetKey).getEndUserCountryCode()));
            subsetKeyDT_EUC2.setSendingEndUsers(((EndUserCounter)object).getSendingEndUserCount());
            subsetKeyDT_EUC2.setReceivingEndUsers(((EndUserCounter)object).getReceivingEndUserCount());
            subsetKeyDT_EUC2.setSendingOrReceivingEndUsers(((EndUserCounter)object).getSendingOrReceivingEndUserCount());
            endUserStatisticsReportType.addSubset((SubsetType)subsetKeyDT_EUC2);
        }
    }

    private static final class EndUserCounter {
        private final ICommonsSet<String> m_aSenders = new CommonsHashSet();
        private final ICommonsSet<String> m_aReceivers = new CommonsHashSet();
        private final ICommonsSet<String> m_aSendersOrReceivers = new CommonsHashSet();

        private EndUserCounter() {
        }

        public void inc(@Nonempty @NonNull String string, boolean bl) {
            if (bl) {
                this.m_aSenders.add((Object)string);
            } else {
                this.m_aReceivers.add((Object)string);
            }
            this.m_aSendersOrReceivers.add((Object)string);
        }

        public @NonNull BigInteger getSendingEndUserCount() {
            return BigHelper.toBigInteger((int)this.m_aSenders.size());
        }

        public @NonNull BigInteger getReceivingEndUserCount() {
            return BigHelper.toBigInteger((int)this.m_aReceivers.size());
        }

        public @NonNull BigInteger getSendingOrReceivingEndUserCount() {
            return BigHelper.toBigInteger((int)this.m_aSendersOrReceivers.size());
        }
    }
}

