/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.tsr.model;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.numeric.BigHelper;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.jaxb.tsr.v101.IncomingOutgoingType;
import com.helger.peppol.reporting.jaxb.tsr.v101.SubtotalKeyType;
import com.helger.peppol.reporting.jaxb.tsr.v101.SubtotalType;
import com.helger.peppol.reporting.jaxb.tsr.v101.TransactionStatisticsReportType;
import com.helger.peppol.reporting.tsr.model.ITSRSubtotalKey;
import com.helger.peppol.reporting.tsr.model.SubtotalKeySP_DT_PR;
import com.helger.peppol.reporting.tsr.model.SubtotalKeySP_DT_PR_CC;
import com.helger.peppol.reporting.tsr.model.SubtotalKeyTP;
import java.math.BigInteger;
import java.util.Map;
import org.jspecify.annotations.NonNull;

@Immutable
public class TSRReportingItemList {
    private TSRReportingItemList() {
    }

    private static @NonNull SubtotalKeyType _createSubtotalKey(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3) {
        SubtotalKeyType subtotalKeyType = new SubtotalKeyType();
        subtotalKeyType.setMetaSchemeID(string);
        subtotalKeyType.setSchemeID(string2);
        subtotalKeyType.setValue(string3);
        return subtotalKeyType;
    }

    public static void fillReportSubsets(@NonNull Iterable<? extends PeppolReportingItem> iterable, @NonNull TransactionStatisticsReportType transactionStatisticsReportType) {
        Object object;
        ITSRSubtotalKey<SubtotalKeyTP> iTSRSubtotalKey;
        long l = 0L;
        long l2 = 0L;
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
        CommonsTreeMap commonsTreeMap2 = new CommonsTreeMap();
        CommonsTreeMap commonsTreeMap3 = new CommonsTreeMap();
        for (PeppolReportingItem object2 : iterable) {
            iTSRSubtotalKey = new SubtotalKeyTP(object2.getTransportProtocol());
            object = new SubtotalKeySP_DT_PR(object2.getOtherServiceProviderID(), object2.getDocTypeIDScheme(), object2.getDocTypeIDValue(), object2.getProcessIDScheme(), object2.getProcessIDValue());
            boolean bl = object2.isReceiving();
            ((TransactionCounter)commonsTreeMap.computeIfAbsent((Object)iTSRSubtotalKey, subtotalKeyTP -> new TransactionCounter())).inc(bl);
            ((TransactionCounter)commonsTreeMap2.computeIfAbsent(object, subtotalKeySP_DT_PR -> new TransactionCounter())).inc(bl);
            if (bl) {
                ++l;
                SubtotalKeySP_DT_PR_CC subtotalKeySP_DT_PR_CC2 = new SubtotalKeySP_DT_PR_CC(object2.getOtherServiceProviderID(), object2.getDocTypeIDScheme(), object2.getDocTypeIDValue(), object2.getProcessIDScheme(), object2.getProcessIDValue(), object2.getC1CountryCode(), object2.getC4CountryCode());
                ((TransactionCounter)commonsTreeMap3.computeIfAbsent((Object)subtotalKeySP_DT_PR_CC2, subtotalKeySP_DT_PR_CC -> new TransactionCounter())).inc(bl);
                continue;
            }
            ++l2;
        }
        IncomingOutgoingType incomingOutgoingType = new IncomingOutgoingType();
        incomingOutgoingType.setIncoming(BigHelper.toBigInteger((long)l));
        incomingOutgoingType.setOutgoing(BigHelper.toBigInteger((long)l2));
        transactionStatisticsReportType.setTotal(incomingOutgoingType);
        for (Map.Entry entry : commonsTreeMap.entrySet()) {
            iTSRSubtotalKey = (SubtotalKeyTP)entry.getKey();
            object = (TransactionCounter)entry.getValue();
            SubtotalType subtotalType = new SubtotalType();
            subtotalType.setType("PerTP");
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("TP", "Peppol", ((SubtotalKeyTP)iTSRSubtotalKey).getTransportProtocol()));
            subtotalType.setIncoming(((TransactionCounter)object).getIncomingCount());
            subtotalType.setOutgoing(((TransactionCounter)object).getOutgoingCount());
            transactionStatisticsReportType.addSubtotal(subtotalType);
        }
        for (Map.Entry entry : commonsTreeMap2.entrySet()) {
            iTSRSubtotalKey = (SubtotalKeySP_DT_PR)entry.getKey();
            object = (TransactionCounter)entry.getValue();
            SubtotalType subtotalType = new SubtotalType();
            subtotalType.setType("PerSP-DT-PR");
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("SP", "CertSubjectCN", ((SubtotalKeySP_DT_PR)iTSRSubtotalKey).getServiceProviderID()));
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("DT", ((SubtotalKeySP_DT_PR)iTSRSubtotalKey).getDocTypeIDScheme(), ((SubtotalKeySP_DT_PR)iTSRSubtotalKey).getDocTypeIDValue()));
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("PR", ((SubtotalKeySP_DT_PR)iTSRSubtotalKey).getProcessIDScheme(), ((SubtotalKeySP_DT_PR)iTSRSubtotalKey).getProcessIDValue()));
            subtotalType.setIncoming(((TransactionCounter)object).getIncomingCount());
            subtotalType.setOutgoing(((TransactionCounter)object).getOutgoingCount());
            transactionStatisticsReportType.addSubtotal(subtotalType);
        }
        for (Map.Entry entry : commonsTreeMap3.entrySet()) {
            iTSRSubtotalKey = (SubtotalKeySP_DT_PR_CC)entry.getKey();
            object = (TransactionCounter)entry.getValue();
            SubtotalType subtotalType = new SubtotalType();
            subtotalType.setType("PerSP-DT-PR-CC");
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("SP", "CertSubjectCN", ((SubtotalKeySP_DT_PR_CC)iTSRSubtotalKey).getServiceProviderID()));
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("DT", ((SubtotalKeySP_DT_PR_CC)iTSRSubtotalKey).getDocTypeIDScheme(), ((SubtotalKeySP_DT_PR_CC)iTSRSubtotalKey).getDocTypeIDValue()));
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("PR", ((SubtotalKeySP_DT_PR_CC)iTSRSubtotalKey).getProcessIDScheme(), ((SubtotalKeySP_DT_PR_CC)iTSRSubtotalKey).getProcessIDValue()));
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("CC", "SenderCountry", ((SubtotalKeySP_DT_PR_CC)iTSRSubtotalKey).getC1CountryCode()));
            subtotalType.addKey(TSRReportingItemList._createSubtotalKey("CC", "ReceiverCountry", ((SubtotalKeySP_DT_PR_CC)iTSRSubtotalKey).getC4CountryCode()));
            subtotalType.setIncoming(((TransactionCounter)object).getIncomingCount());
            subtotalType.setOutgoing(((TransactionCounter)object).getOutgoingCount());
            transactionStatisticsReportType.addSubtotal(subtotalType);
        }
    }

    private static final class TransactionCounter {
        private long m_nIncoming = 0L;
        private long m_nOutgoing = 0L;

        private TransactionCounter() {
        }

        public void inc(boolean bl) {
            if (bl) {
                ++this.m_nIncoming;
            } else {
                ++this.m_nOutgoing;
            }
        }

        public @NonNull BigInteger getIncomingCount() {
            return BigHelper.toBigInteger((long)this.m_nIncoming);
        }

        public @NonNull BigInteger getOutgoingCount() {
            return BigHelper.toBigInteger((long)this.m_nOutgoing);
        }
    }
}

