/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dynamicdiscovery;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.phase4.dynamicdiscovery.IAS4EndpointDetailProvider;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.util.Phase4Exception;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;

public class AS4EndpointDetailProviderConstant
implements IAS4EndpointDetailProvider {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4EndpointDetailProviderConstant.class);
    private final X509Certificate m_aReceiverCert;
    private final String m_sDestURL;
    private final String m_sTechnicalContact;

    public AS4EndpointDetailProviderConstant(@Nullable X509Certificate x509Certificate, @Nonnull @Nonempty String string) {
        this(x509Certificate, string, null);
    }

    public AS4EndpointDetailProviderConstant(@Nullable X509Certificate x509Certificate, @Nonnull @Nonempty String string, @Nullable String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DestURL");
        this.m_aReceiverCert = x509Certificate;
        this.m_sDestURL = string;
        this.m_sTechnicalContact = string2;
        if (x509Certificate != null) {
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                LOGGER.warn("The provided Endpoint certificate is already expired. Please use a different one: " + certificateExpiredException.getMessage());
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                LOGGER.warn("The provided Endpoint certificate is not yet valid. Please use a different one: " + certificateNotYetValidException.getMessage());
            }
        }
    }

    @Override
    public void init(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier) {
    }

    @Override
    @Nullable
    public X509Certificate getReceiverAPCertificate() {
        return this.m_aReceiverCert;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getReceiverAPEndpointURL() {
        return this.m_sDestURL;
    }

    @Override
    @Nullable
    public String getReceiverTechnicalContact() throws Phase4Exception {
        return this.m_sTechnicalContact;
    }

    public String toString() {
        return new ToStringGenerator(null).append("ReceiverCert", (Object)this.m_aReceiverCert).append("DestURL", (Object)this.m_sDestURL).appendIfNotNull("TechnicalContact", (Object)this.m_sTechnicalContact).getToString();
    }
}

