/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dynamicdiscovery;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.phase4.dynamicdiscovery.IAS4EndpointDetailProvider;
import com.helger.phase4.dynamicdiscovery.Phase4SMPException;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.util.Phase4Exception;
import com.helger.smpclient.exception.SMPClientBadRequestException;
import com.helger.smpclient.exception.SMPClientBadResponseException;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientUnauthorizedException;
import com.helger.smpclient.peppol.ISMPExtendedServiceMetadataProvider;
import com.helger.smpclient.peppol.ISMPServiceGroupProvider;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.xsds.peppol.smp1.EndpointType;
import com.helger.xsds.peppol.smp1.ServiceMetadataType;
import com.helger.xsds.peppol.smp1.SignedServiceMetadataType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import org.slf4j.Logger;

public class AS4EndpointDetailProviderPeppol
implements IAS4EndpointDetailProvider {
    public static final ISMPTransportProfile DEFAULT_TRANSPORT_PROFILE = ESMPTransportProfile.TRANSPORT_PROFILE_PEPPOL_AS4_V2;
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4EndpointDetailProviderPeppol.class);
    private final ISMPServiceGroupProvider m_aServiceGroupProvider;
    private final ISMPExtendedServiceMetadataProvider m_aServiceMetadataProvider;
    private ISMPTransportProfile m_aTP = DEFAULT_TRANSPORT_PROFILE;
    private EndpointType m_aEndpoint;

    public AS4EndpointDetailProviderPeppol(@Nonnull ISMPServiceGroupProvider iSMPServiceGroupProvider, @Nonnull ISMPExtendedServiceMetadataProvider iSMPExtendedServiceMetadataProvider) {
        ValueEnforcer.notNull((Object)iSMPServiceGroupProvider, (String)"ServiceGroupProvider");
        ValueEnforcer.notNull((Object)iSMPExtendedServiceMetadataProvider, (String)"ServiceMetadataProvider");
        this.m_aServiceGroupProvider = iSMPServiceGroupProvider;
        this.m_aServiceMetadataProvider = iSMPExtendedServiceMetadataProvider;
    }

    @Nonnull
    public final ISMPServiceGroupProvider getServiceGroupProvider() {
        return this.m_aServiceGroupProvider;
    }

    @Nonnull
    public final ISMPServiceMetadataProvider getServiceMetadataProvider() {
        return this.m_aServiceMetadataProvider;
    }

    @Nonnull
    public final ISMPTransportProfile getTransportProfile() {
        return this.m_aTP;
    }

    @Nonnull
    public final AS4EndpointDetailProviderPeppol setTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        this.m_aTP = iSMPTransportProfile;
        return this;
    }

    @Nullable
    public final EndpointType getEndpoint() {
        return this.m_aEndpoint;
    }

    @Nullable
    @OverrideOnDemand
    protected SignedServiceMetadataType resolvedSchemeSpecificServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.m_aServiceMetadataProvider.getSchemeSpecificServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Override
    public void init(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws Phase4Exception {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ReceiverID");
        if (this.m_aEndpoint == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start performing SMP lookup (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")");
            }
            try {
                boolean bl;
                SignedServiceMetadataType signedServiceMetadataType = this.resolvedSchemeSpecificServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
                boolean bl2 = bl = signedServiceMetadataType != null && "peppol-doctype-wildcard".equals(iDocumentTypeIdentifier.getScheme()) && iDocumentTypeIdentifier.getValue().indexOf(42) >= 0;
                if (signedServiceMetadataType != null) {
                    this.m_aEndpoint = SMPClientReadOnly.getEndpointAt((ServiceMetadataType)signedServiceMetadataType.getServiceMetadata(), (IProcessIdentifier)iProcessIdentifier, (ISMPTransportProfile)this.m_aTP, (LocalDateTime)PDTFactory.getCurrentLocalDateTime());
                }
                if (this.m_aEndpoint == null) {
                    throw new Phase4SMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")" + (bl ? " [wildcard]" : " [static]"));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully resolved SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")" + (bl ? " [wildcard]" : " [static]"));
                }
            }
            catch (SMPClientException sMPClientException) {
                boolean bl = sMPClientException instanceof SMPClientBadRequestException || sMPClientException instanceof SMPClientBadResponseException || sMPClientException instanceof SMPClientUnauthorizedException || ((Object)((Object)sMPClientException)).getClass().equals(SMPClientException.class);
                throw new Phase4SMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")", sMPClientException).setRetryFeasible(bl);
            }
        }
    }

    @Override
    @Nullable
    public X509Certificate getReceiverAPCertificate() throws Phase4Exception {
        try {
            return SMPClientReadOnly.getEndpointCertificate((EndpointType)this.m_aEndpoint);
        }
        catch (CertificateException certificateException) {
            throw new Phase4Exception("Failed to extract AP certificate from SMP endpoint: " + String.valueOf(this.m_aEndpoint), (Throwable)certificateException).setRetryFeasible(false);
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public String getReceiverAPEndpointURL() throws Phase4Exception {
        String string = SMPClientReadOnly.getEndpointAddress((EndpointType)this.m_aEndpoint);
        if (StringHelper.isEmpty((String)string)) {
            throw new Phase4Exception("Failed to determine the destination URL from the SMP endpoint: " + String.valueOf(this.m_aEndpoint));
        }
        return string;
    }

    @Override
    @Nullable
    public String getReceiverTechnicalContact() throws Phase4Exception {
        return this.m_aEndpoint.getTechnicalContactUrl();
    }

    public String toString() {
        return new ToStringGenerator(null).append("ServiceGroupProvider", (Object)this.m_aServiceGroupProvider).append("ServiceMetadataProvider", (Object)this.m_aServiceMetadataProvider).append("TransportProfile", (Object)this.m_aTP).appendIfNotNull("Endpoint", (Object)this.m_aEndpoint).getToString();
    }

    @Nonnull
    public static AS4EndpointDetailProviderPeppol create(@Nonnull SMPClientReadOnly sMPClientReadOnly) {
        return new AS4EndpointDetailProviderPeppol((ISMPServiceGroupProvider)sMPClientReadOnly, (ISMPExtendedServiceMetadataProvider)sMPClientReadOnly);
    }
}

