/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.util.AS4ResourceHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface IAS4Attachment {
    public String getId();

    public String getMimeType();

    @Nullable
    public String getUncompressedMimeType();

    @Nonnull
    public InputStream getSourceStream();

    @Nonnull
    public InputStream getSourceStream(@Nonnull AS4ResourceHelper var1);

    @Nullable
    public IHasInputStream getInputStreamProvider();

    default public boolean isRepeatable() {
        IHasInputStream iHasInputStream = this.getInputStreamProvider();
        return iHasInputStream != null && iHasInputStream.isReadMultiple();
    }

    @Nonnull
    public EContentTransferEncoding getContentTransferEncoding();

    @Nullable
    public EAS4CompressionMode getCompressionMode();

    default public boolean hasCompressionMode() {
        return this.getCompressionMode() != null;
    }

    @Nonnull
    default public Charset getCharset() {
        return this.getCharsetOrDefault(StandardCharsets.ISO_8859_1);
    }

    @Nullable
    public Charset getCharsetOrDefault(@Nullable Charset var1);

    public boolean hasCharset();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, String> customPartProperties();
}

