/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.phase4.crypto.AbstractAS4CryptoFactory;
import com.helger.phase4.crypto.ECryptoMode;
import com.helger.security.keystore.IKeyStoreAndKeyDescriptor;
import com.helger.security.keystore.ITrustStoreDescriptor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.KeyStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;

@Immutable
public class AS4CryptoFactoryInMemoryKeyStore
extends AbstractAS4CryptoFactory {
    private final KeyStore m_aKeyStore;
    private final String m_sKeyAlias;
    private final char[] m_aKeyPassword;
    private final KeyStore m_aTrustStore;
    private Merlin m_aCrypto;

    public AS4CryptoFactoryInMemoryKeyStore(@Nonnull IKeyStoreAndKeyDescriptor iKeyStoreAndKeyDescriptor, @Nullable ITrustStoreDescriptor iTrustStoreDescriptor) {
        this(iKeyStoreAndKeyDescriptor.loadKeyStore().getKeyStore(), iKeyStoreAndKeyDescriptor.getKeyAlias(), iKeyStoreAndKeyDescriptor.getKeyPassword(), iTrustStoreDescriptor == null ? null : iTrustStoreDescriptor.loadTrustStore().getKeyStore());
    }

    public AS4CryptoFactoryInMemoryKeyStore(@Nonnull KeyStore keyStore, @Nonnull @Nonempty String string, @Nonnull char[] cArray, @Nullable KeyStore keyStore2) {
        ValueEnforcer.notNull((Object)keyStore, (String)"KeyStore");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"KeyAlias");
        ValueEnforcer.notNull((Object)cArray, (String)"KeyPassword");
        this.m_aKeyStore = keyStore;
        this.m_sKeyAlias = string;
        this.m_aKeyPassword = cArray;
        this.m_aTrustStore = keyStore2;
    }

    @Override
    @Nonnull
    public Crypto getCrypto(@Nonnull ECryptoMode eCryptoMode) {
        Merlin merlin = this.m_aCrypto;
        if (merlin == null) {
            merlin = this.m_aCrypto = new Merlin(this.m_aTrustStore == null, "changeit");
            merlin.setKeyStore(this.m_aKeyStore);
            merlin.setTrustStore(this.m_aTrustStore);
        }
        return merlin;
    }

    @Override
    @Nonnull
    public final KeyStore getKeyStore() {
        return this.m_aKeyStore;
    }

    @Override
    @Nonnull
    public final String getKeyAlias() {
        return this.m_sKeyAlias;
    }

    @Override
    @Nullable
    public char[] getKeyPasswordPerAliasCharArray(@Nullable String string) {
        if (this.m_sKeyAlias != null && string != null && this.m_sKeyAlias.equalsIgnoreCase(string)) {
            return this.m_aKeyPassword;
        }
        return null;
    }

    @Override
    @Nullable
    public final KeyStore getTrustStore() {
        return this.m_aTrustStore;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("KeyStore?", this.m_aKeyStore != null).append("KeyAlias", (Object)this.m_sKeyAlias).appendPassword("KeyPassword").append("TrustStore?", this.m_aTrustStore != null).getToString();
    }
}

