/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.base.string.StringHelper;
import com.helger.phase4.crypto.ICryptoAlgorithmSignDigest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum ECryptoAlgorithmSignDigest implements ICryptoAlgorithmSignDigest
{
    DIGEST_SHA_256("sha-256", "http://www.w3.org/2001/04/xmlenc#sha256"),
    DIGEST_SHA_384("sha-384", "http://www.w3.org/2001/04/xmldsig-more#sha384"),
    DIGEST_SHA_512("sha-512", "http://www.w3.org/2001/04/xmlenc#sha512");

    public static final ECryptoAlgorithmSignDigest SIGN_DIGEST_ALGORITHM_DEFAULT;
    private final String m_sID;
    private final String m_sAlgorithmURI;

    private ECryptoAlgorithmSignDigest(String string2, String string3) {
        this.m_sID = string2;
        this.m_sAlgorithmURI = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAlgorithmURI() {
        return this.m_sAlgorithmURI;
    }

    @Nullable
    public static ECryptoAlgorithmSignDigest getFromIDOrNull(@Nullable String string) {
        return (ECryptoAlgorithmSignDigest)EnumHelper.getFromIDOrNull(ECryptoAlgorithmSignDigest.class, (Object)string);
    }

    @Nonnull
    public static ECryptoAlgorithmSignDigest getFromIDOrThrow(@Nullable String string) {
        return (ECryptoAlgorithmSignDigest)EnumHelper.getFromIDOrThrow(ECryptoAlgorithmSignDigest.class, (Object)string);
    }

    @Nullable
    public static ECryptoAlgorithmSignDigest getFromIDOrDefault(@Nullable String string, @Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest) {
        return (ECryptoAlgorithmSignDigest)EnumHelper.getFromIDOrDefault(ECryptoAlgorithmSignDigest.class, (Object)string, (Enum)eCryptoAlgorithmSignDigest);
    }

    @Nullable
    public static ECryptoAlgorithmSignDigest getFromURIOrNull(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (ECryptoAlgorithmSignDigest)EnumHelper.findFirst(ECryptoAlgorithmSignDigest.class, eCryptoAlgorithmSignDigest -> eCryptoAlgorithmSignDigest.getAlgorithmURI().equals(string));
    }

    static {
        SIGN_DIGEST_ALGORITHM_DEFAULT = DIGEST_SHA_256;
    }
}

