/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum ECryptoKeyIdentifierType implements IHasID<String>
{
    BST_DIRECT_REFERENCE("bst", 1),
    ISSUER_SERIAL("issuer-serial", 2),
    X509_KEY_IDENTIFIER("x509-key-id", 3),
    SKI_KEY_IDENTIFIER("ski-key-id", 4),
    X509_SKI_KEY_IDENTIFIER("x509-ski-key-id", 16),
    UT_SIGNING("ui-signing", 7),
    THUMBPRINT_IDENTIFIER("thumbprint-id", 8),
    CUSTOM_SYMM_SIGNING("custom-symm-signing", 9),
    ENCRYPTED_KEY_SHA1_IDENTIFIER("encry-key-sha1-id", 10),
    CUSTOM_SYMM_SIGNING_DIRECT("custom-symm-signing-default", 11),
    CUSTOM_KEY_IDENTIFIER("custom-key-id", 12),
    KEY_VALUE("key-value", 13),
    ENDPOINT_KEY_IDENTIFIER("endpoint-key-id", 14),
    ISSUER_SERIAL_QUOTE_FORMAT("issuer-serial-quote-format", 15);

    private final String m_sID;
    private final int m_nTypeID;

    private ECryptoKeyIdentifierType(String string2, int n2) {
        this.m_sID = string2;
        this.m_nTypeID = n2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    public int getTypeID() {
        return this.m_nTypeID;
    }

    @Nullable
    public static ECryptoKeyIdentifierType getFromIDOrNull(@Nullable String string) {
        return (ECryptoKeyIdentifierType)EnumHelper.getFromIDOrNull(ECryptoKeyIdentifierType.class, (Object)string);
    }

    @Nonnull
    public static ECryptoKeyIdentifierType getFromIDOrThrow(@Nullable String string) {
        return (ECryptoKeyIdentifierType)EnumHelper.getFromIDOrThrow(ECryptoKeyIdentifierType.class, (Object)string);
    }

    @Nullable
    public static ECryptoKeyIdentifierType getFromIDOrDefault(@Nullable String string, @Nullable ECryptoKeyIdentifierType eCryptoKeyIdentifierType) {
        return (ECryptoKeyIdentifierType)EnumHelper.getFromIDOrDefault(ECryptoKeyIdentifierType.class, (Object)string, (Enum)eCryptoKeyIdentifierType);
    }

    @Nullable
    public static ECryptoKeyIdentifierType getFromTypeIDOrNull(int n) {
        return (ECryptoKeyIdentifierType)EnumHelper.findFirst(ECryptoKeyIdentifierType.class, eCryptoKeyIdentifierType -> eCryptoKeyIdentifierType.getTypeID() == n);
    }
}

