/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import jakarta.annotation.Nonnull;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;

public interface ICryptoSessionKeyProvider {
    public static final ICryptoSessionKeyProvider INSTANCE_RANDOM_AES_128 = () -> {
        try {
            KeyGenerator keyGenerator = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            return keyGenerator.generateKey();
        }
        catch (WSSecurityException wSSecurityException) {
            throw new IllegalStateException("Failed to create session key (AES-128)", wSSecurityException);
        }
    };
    public static final ICryptoSessionKeyProvider INSTANCE_RANDOM_AES_256 = () -> {
        try {
            KeyGenerator keyGenerator = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            return keyGenerator.generateKey();
        }
        catch (WSSecurityException wSSecurityException) {
            throw new IllegalStateException("Failed to create session key (AES-256)", wSSecurityException);
        }
    };

    @Nonnull
    public SecretKey getSessionKey();
}

