/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingBufferedOutputStream;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.http.CHttp;
import com.helger.http.header.HttpHeaderMap;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FilenameHelper;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.sender.AbstractAS4RawResponseConsumer;
import com.helger.phase4.util.Phase4Exception;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class AS4RawResponseConsumerWriteToFile
extends AbstractAS4RawResponseConsumer<AS4RawResponseConsumerWriteToFile> {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4RawResponseConsumerWriteToFile.class);
    private final IFileProvider m_aFileProvider;
    private Consumer<? super File> m_aFileOpenCallback;

    public AS4RawResponseConsumerWriteToFile() {
        this(string -> new File(AS4Configuration.getDumpBasePathFile(), "outgoing/" + IFileProvider.getFilename(string)));
    }

    public AS4RawResponseConsumerWriteToFile(@Nonnull IFileProvider iFileProvider) {
        ValueEnforcer.notNull((Object)iFileProvider, (String)"FileProvider");
        this.m_aFileProvider = iFileProvider;
    }

    @Nullable
    public final Consumer<? super File> getFileOpenCallback() {
        return this.m_aFileOpenCallback;
    }

    @Nonnull
    public final AS4RawResponseConsumerWriteToFile setFileOpenCallback(@Nonnull Consumer<? super File> consumer) {
        this.m_aFileOpenCallback = consumer;
        return this;
    }

    @Override
    public void handleResponse(@Nonnull AS4ClientSentMessage<byte[]> aS4ClientSentMessage) throws Phase4Exception {
        boolean bl;
        boolean bl2 = this.isHandleStatusLine() && aS4ClientSentMessage.hasResponseStatusLine();
        boolean bl3 = this.isHandleHttpHeaders() && aS4ClientSentMessage.getResponseHeaders().isNotEmpty();
        boolean bl4 = bl = aS4ClientSentMessage.hasResponseContent() && aS4ClientSentMessage.getResponseContent().length > 0;
        if (bl2 || bl3 || bl) {
            String string = aS4ClientSentMessage.getMessageID();
            File file = this.m_aFileProvider.createFile(string);
            LOGGER.info("Logging AS4 response to '" + file.getAbsolutePath() + "'");
            if (this.m_aFileOpenCallback != null) {
                this.m_aFileOpenCallback.accept(file);
            }
            try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream((File)file);){
                if (nonBlockingBufferedOutputStream != null) {
                    if (bl2) {
                        nonBlockingBufferedOutputStream.write(aS4ClientSentMessage.getResponseStatusLine().toString().getBytes(CHttp.HTTP_CHARSET));
                    }
                    if (bl3) {
                        for (Map.Entry entry : aS4ClientSentMessage.getResponseHeaders()) {
                            String string2 = (String)entry.getKey();
                            for (String string3 : (ICommonsList)entry.getValue()) {
                                String string4 = HttpHeaderMap.getUnifiedValue((String)string3, (boolean)false);
                                nonBlockingBufferedOutputStream.write((string2 + ": " + string4 + "\r\n").getBytes(CHttp.HTTP_CHARSET));
                            }
                        }
                    }
                    if ((bl2 || bl3) && bl) {
                        nonBlockingBufferedOutputStream.write("\r\n".getBytes(CHttp.HTTP_CHARSET));
                    }
                    if (bl) {
                        nonBlockingBufferedOutputStream.write(aS4ClientSentMessage.getResponseContent());
                    }
                } else {
                    LOGGER.error("Failed to open the AS4 response file '" + file.getAbsolutePath() + "' for writing!");
                }
            }
            catch (IOException iOException) {
                throw new Phase4Exception("Error writing AS4 response file to '" + file.getAbsolutePath() + "'", iOException);
            }
        }
    }

    @Nonnull
    public static AS4RawResponseConsumerWriteToFile createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"BaseDirectory");
        return new AS4RawResponseConsumerWriteToFile(string -> new File(file, IFileProvider.getFilename(string)));
    }

    @FunctionalInterface
    public static interface IFileProvider {
        public static final String DEFAULT_FILE_EXTENSION = ".as4response";

        @Nonnull
        public File createFile(@Nonnull String var1);

        @Nonnull
        public static String getFilename(@Nonnull String string) {
            OffsetDateTime offsetDateTime = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
            return offsetDateTime.getYear() + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getMonthValue(), (int)2) + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getDayOfMonth(), (int)2) + "/" + PDTIOHelper.getTimeForFilename((LocalTime)offsetDateTime.toLocalTime()) + "-" + FilenameHelper.getAsSecureValidASCIIFilename((String)string) + DEFAULT_FILE_EXTENSION;
        }
    }
}

