/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.base.string.StringHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.http.header.HttpHeaderMap;
import com.helger.io.file.FilenameHelper;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.time.LocalTime;
import java.time.OffsetDateTime;

@FunctionalInterface
public interface IAS4IncomingDumperFileProvider {
    public static final String DEFAULT_FILE_EXTENSION = ".as4in";

    @Nonnull
    public File createFile(@Nonnull IAS4IncomingMessageMetadata var1, @Nonnull HttpHeaderMap var2);

    @Nonnull
    public static String getDefaultDirectoryName(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        OffsetDateTime offsetDateTime = iAS4IncomingMessageMetadata.getIncomingDT();
        return offsetDateTime.getYear() + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getMonthValue(), (int)2) + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getDayOfMonth(), (int)2);
    }

    @Nonnull
    public static String getDefaultFilename(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        OffsetDateTime offsetDateTime = iAS4IncomingMessageMetadata.getIncomingDT();
        return PDTIOHelper.getTimeForFilename((LocalTime)offsetDateTime.toLocalTime()) + "-" + FilenameHelper.getAsSecureValidASCIIFilename((String)iAS4IncomingMessageMetadata.getIncomingUniqueID()) + DEFAULT_FILE_EXTENSION;
    }

    @Nonnull
    public static String getDefaultDirectoryAndFilename(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        return IAS4IncomingDumperFileProvider.getDefaultDirectoryName(iAS4IncomingMessageMetadata) + "/" + IAS4IncomingDumperFileProvider.getDefaultFilename(iAS4IncomingMessageMetadata);
    }
}

