/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.duplicate;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.phase4.duplicate.AS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.function.Predicate;

@ThreadSafe
public class AS4DuplicateManagerInMemory
implements IAS4DuplicateManager {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, AS4DuplicateItem> m_aMap = new CommonsHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EContinue registerAndCheck(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        if (StringHelper.isEmpty((String)string)) {
            return EContinue.CONTINUE;
        }
        AS4DuplicateItem aS4DuplicateItem = new AS4DuplicateItem(string, string2, string3);
        this.m_aRWLock.writeLock().lock();
        try {
            String string4 = aS4DuplicateItem.getID();
            if (this.m_aMap.containsKey((Object)string4)) {
                EContinue eContinue = EContinue.BREAK;
                return eContinue;
            }
            this.m_aMap.put((Object)string4, (Object)aS4DuplicateItem);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange clearCache() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> this.m_aMap.removeAll());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> evictAllItemsBefore(@Nonnull OffsetDateTime offsetDateTime) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.readLocked(() -> this.lambda$evictAllItemsBefore$2(offsetDateTime, (ICommonsList)commonsArrayList));
        if (commonsArrayList.isNotEmpty()) {
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aMap.removeIfKey(arg_0 -> ((ICommonsList)commonsArrayList).contains(arg_0));
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return commonsArrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.isEmpty());
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.size());
    }

    @Nullable
    public IAS4DuplicateItem findFirst(@Nonnull Predicate<? super IAS4DuplicateItem> predicate) {
        return (IAS4DuplicateItem)this.m_aRWLock.readLockedGet(() -> (AS4DuplicateItem)CollectionFind.findFirst((Iterable)this.m_aMap.values(), (Predicate)predicate));
    }

    @Override
    @Nullable
    public IAS4DuplicateItem getItemOfMessageID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return this.findFirst(iAS4DuplicateItem -> iAS4DuplicateItem.getMessageID().equals(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAS4DuplicateItem> getAll() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aMap.values()));
    }

    public String toString() {
        return new ToStringGenerator(null).append("Map", this.m_aMap).getToString();
    }

    private /* synthetic */ void lambda$evictAllItemsBefore$2(OffsetDateTime offsetDateTime, ICommonsList iCommonsList) {
        this.m_aMap.forEachValue(aS4DuplicateItem -> aS4DuplicateItem.getDateTime().isBefore(offsetDateTime), aS4DuplicateItem -> iCommonsList.add((Object)aS4DuplicateItem.getMessageID()));
    }
}

