/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.duplicate;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.dao.DAOException;
import com.helger.phase4.duplicate.AS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateItem;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import com.helger.photon.io.dao.AbstractPhotonMapBasedWALDAO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;

@ThreadSafe
public class AS4DuplicateManagerXML
extends AbstractPhotonMapBasedWALDAO<IAS4DuplicateItem, AS4DuplicateItem>
implements IAS4DuplicateManager {
    public AS4DuplicateManagerXML(@Nullable String string) throws DAOException {
        super(AS4DuplicateItem.class, string);
    }

    @Override
    @Nonnull
    public EContinue registerAndCheck(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        if (StringHelper.isEmpty((String)string)) {
            return EContinue.CONTINUE;
        }
        AS4DuplicateItem aS4DuplicateItem = new AS4DuplicateItem(string, string2, string3);
        try {
            this.m_aRWLock.writeLocked(() -> this.internalCreateItem(aS4DuplicateItem));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange clearCache() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> this.internalRemoveAllItemsNoCallback());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> evictAllItemsBefore(@Nonnull OffsetDateTime offsetDateTime) {
        ICommonsList iCommonsList = this.getAllMapped(iAS4DuplicateItem -> iAS4DuplicateItem.getDateTime().isBefore(offsetDateTime), IAS4DuplicateItem::getMessageID);
        if (iCommonsList.isNotEmpty()) {
            this.m_aRWLock.writeLocked(() -> {
                for (String string : iCommonsList) {
                    this.internalDeleteItem(string);
                }
            });
        }
        return iCommonsList;
    }

    @Override
    @Nullable
    public IAS4DuplicateItem getItemOfMessageID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (IAS4DuplicateItem)this.findFirst(iAS4DuplicateItem -> iAS4DuplicateItem.getMessageID().equals(string));
    }
}

