/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.incoming.mgr.AS4DuplicateCleanupJob;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.quartz.TriggerKey;
import org.slf4j.Logger;

@ThreadSafe
public final class AS4ServerInitializer {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4ServerInitializer.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static TriggerKey s_aTriggerKey;

    private AS4ServerInitializer() {
    }

    public static void initAS4Server() {
        MetaAS4Manager.getInstance();
        long l = AS4Configuration.getIncomingDuplicateDisposalMinutes();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Scheduling AS4DuplicateCleanupJob to dispose incoming metadata that is older than " + l + " minutes");
        }
        RW_LOCK.writeLocked(() -> {
            TriggerKey triggerKey = AS4DuplicateCleanupJob.scheduleMe(l);
            if (triggerKey != null) {
                if (s_aTriggerKey != null) {
                    throw new IllegalStateException("Failed to schedule AS4DuplicateCleanupJob - seems like some cleanup is missing");
                }
                s_aTriggerKey = triggerKey;
            }
        });
    }

    public static void shutdownAS4Server() {
        RW_LOCK.writeLocked(() -> {
            AS4DuplicateCleanupJob.unschedule(s_aTriggerKey);
            s_aTriggerKey = null;
        });
    }
}

