/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.soap;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4DecryptParameterModifier;
import com.helger.phase4.crypto.IAS4PModeAwareCryptoFactory;
import com.helger.phase4.incoming.IAS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.crypto.IAS4IncomingSecurityConfiguration;
import com.helger.phase4.incoming.soap.ISoapHeaderElementProcessor;
import com.helger.phase4.incoming.soap.SoapHeaderElementProcessorExtractEbms3Messaging;
import com.helger.phase4.incoming.soap.SoapHeaderElementProcessorWSS4J;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.resolve.IAS4PModeResolver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.Provider;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.slf4j.Logger;

@NotThreadSafe
public class SoapHeaderElementProcessorRegistry {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(SoapHeaderElementProcessorRegistry.class);
    private final ICommonsOrderedMap<QName, ISoapHeaderElementProcessor> m_aMap = new CommonsLinkedHashMap();

    public void registerHeaderElementProcessor(@Nonnull QName qName, @Nonnull ISoapHeaderElementProcessor iSoapHeaderElementProcessor) {
        ValueEnforcer.notNull((Object)qName, (String)"QName");
        ValueEnforcer.notNull((Object)iSoapHeaderElementProcessor, (String)"Processor");
        if (this.m_aMap.containsKey((Object)qName)) {
            throw new IllegalArgumentException("A processor for QName " + qName.toString() + " is already registered!");
        }
        this.m_aMap.put((Object)qName, (Object)iSoapHeaderElementProcessor);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully registered SOAP header element processor for " + qName.toString());
        }
    }

    @Nullable
    public ISoapHeaderElementProcessor getHeaderElementProcessor(@Nullable QName qName) {
        if (qName == null) {
            return null;
        }
        return (ISoapHeaderElementProcessor)this.m_aMap.get((Object)qName);
    }

    public boolean containsHeaderElementProcessor(@Nullable QName qName) {
        return qName != null && this.m_aMap.containsKey((Object)qName);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<QName, ISoapHeaderElementProcessor> getAllElementProcessors() {
        return this.m_aMap.getClone();
    }

    @Nonnull
    public static SoapHeaderElementProcessorRegistry createDefault(@Nonnull IAS4PModeResolver iAS4PModeResolver, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nullable IPMode iPMode2, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration) {
        SoapHeaderElementProcessorRegistry soapHeaderElementProcessorRegistry = new SoapHeaderElementProcessorRegistry();
        Consumer<IPMode> consumer = iPMode -> {
            if (iAS4CryptoFactory instanceof IAS4PModeAwareCryptoFactory) {
                ((IAS4PModeAwareCryptoFactory)iAS4CryptoFactory).setContextPMode((IPMode)iPMode);
            }
            if (!EqualsHelper.identityEqual((Object)iAS4CryptoFactory, (Object)iAS4CryptoFactory2) && iAS4CryptoFactory2 instanceof IAS4PModeAwareCryptoFactory) {
                ((IAS4PModeAwareCryptoFactory)iAS4CryptoFactory2).setContextPMode((IPMode)iPMode);
            }
        };
        soapHeaderElementProcessorRegistry.registerHeaderElementProcessor(SoapHeaderElementProcessorExtractEbms3Messaging.QNAME_MESSAGING, new SoapHeaderElementProcessorExtractEbms3Messaging(iAS4PModeResolver, consumer, iAS4IncomingReceiverConfiguration));
        AS4SigningParams aS4SigningParams = iAS4IncomingSecurityConfiguration.getSigningParams();
        Provider provider = aS4SigningParams == null ? null : aS4SigningParams.getSecurityProviderVerify();
        Supplier<IPMode> supplier = () -> iPMode2;
        IAS4DecryptParameterModifier iAS4DecryptParameterModifier = iAS4IncomingSecurityConfiguration.getDecryptParameterModifier();
        soapHeaderElementProcessorRegistry.registerHeaderElementProcessor(SoapHeaderElementProcessorWSS4J.QNAME_SECURITY, new SoapHeaderElementProcessorWSS4J(iAS4CryptoFactory, iAS4CryptoFactory2, provider, supplier, iAS4DecryptParameterModifier, aS4SigningParams));
        return soapHeaderElementProcessorRegistry;
    }
}

