/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.http;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.marshaller.Ebms3NamespaceHandler;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.annotation.Nonnull;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;

@ThreadSafe
public final class AS4HttpDebug {
    public static final boolean DEFAULT_DEBUG = false;
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4HttpDebug.class);
    private static final AtomicBoolean ENABLED = new AtomicBoolean(false);
    private static final XMLWriterSettings XWS = new XMLWriterSettings().setIndent(EXMLSerializeIndent.INDENT_AND_ALIGN).setNamespaceContext((NamespaceContext)((Object)Ebms3NamespaceHandler.getInstance()));

    private AS4HttpDebug() {
    }

    public static void setEnabled(boolean bl) {
        ENABLED.set(bl);
    }

    public static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void debug(@Nonnull Supplier<? super String> supplier) {
        if (AS4HttpDebug.isEnabled()) {
            LOGGER.info("$$$ AS4 HTTP [" + MetaAS4Manager.getTimestampMgr().getCurrentDateTime().toString() + "] " + String.valueOf(supplier.get()));
        }
    }

    @Nonnull
    public static IXMLWriterSettings getDebugXMLWriterSettings() {
        return XWS;
    }
}

