/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.http;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.base.concurrent.ThreadHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.wrapper.Wrapper;
import com.helger.http.header.HttpHeaderMap;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.messaging.EAS4MessageMode;
import com.helger.phase4.messaging.http.AS4HttpDebug;
import com.helger.phase4.messaging.http.HttpRetrySettings;
import com.helger.phase4.messaging.http.IHttpPoster;
import com.helger.phase4.util.MultiOutputStream;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.slf4j.Logger;

public class BasicHttpPoster
implements IHttpPoster {
    public static final boolean DEFAULT_QUOTE_HTTP_HEADERS = false;
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(BasicHttpPoster.class);
    private HttpClientFactory m_aHttpClientFactory = BasicHttpPoster.createDefaultHttpClientFactory();
    private Consumer<? super HttpPost> m_aHttpCustomizer;
    private boolean m_bQuoteHttpHeaders = false;

    @Nonnull
    public static HttpClientFactory createDefaultHttpClientFactory() {
        return new HttpClientFactory();
    }

    @Override
    @Nonnull
    public final HttpClientFactory getHttpClientFactory() {
        return this.m_aHttpClientFactory;
    }

    @Override
    @Nonnull
    public final BasicHttpPoster setHttpClientFactory(@Nonnull HttpClientFactory httpClientFactory) {
        ValueEnforcer.notNull((Object)httpClientFactory, (String)"HttpClientFactory");
        this.m_aHttpClientFactory = httpClientFactory;
        return this;
    }

    @Override
    @Nullable
    public final Consumer<? super HttpPost> getHttpCustomizer() {
        return this.m_aHttpCustomizer;
    }

    @Override
    @Nonnull
    public final BasicHttpPoster setHttpCustomizer(@Nullable Consumer<? super HttpPost> consumer) {
        this.m_aHttpCustomizer = consumer;
        return this;
    }

    @Override
    public final boolean isQuoteHttpHeaders() {
        return this.m_bQuoteHttpHeaders;
    }

    @Override
    @Nonnull
    public final BasicHttpPoster setQuoteHttpHeaders(boolean bl) {
        this.m_bQuoteHttpHeaders = bl;
        return this;
    }

    @Override
    @Nullable
    public <T> T sendGenericMessage(@Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnull HttpEntity httpEntity, @Nonnull HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws IOException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URL");
        ValueEnforcer.notNull((Object)httpEntity, (String)"HttpEntity");
        StopWatch stopWatch = StopWatch.createdStarted();
        LOGGER.info("Starting to transmit AS4 Message to '" + string + "'");
        IOException iOException = null;
        try {
            Object object;
            HttpClientManager httpClientManager = new HttpClientManager((IHttpClientProvider)this.m_aHttpClientFactory);
            try {
                HttpPost httpPost = new HttpPost(string);
                if (httpHeaderMap != null) {
                    httpHeaderMap.forEachSingleHeader((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1), true, this.m_bQuoteHttpHeaders);
                }
                httpPost.setEntity(httpEntity);
                if (this.m_aHttpCustomizer != null) {
                    this.m_aHttpCustomizer.accept((HttpPost)httpPost);
                }
                AS4HttpDebug.debug(() -> {
                    StringBuilder stringBuilder = new StringBuilder("SEND-START to ").append(string).append("\n");
                    try {
                        for (Header header : httpPost.getHeaders()) {
                            stringBuilder.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
                        }
                        stringBuilder.append("\r\n");
                        if (httpEntity.isRepeatable()) {
                            stringBuilder.append(EntityUtils.toString((HttpEntity)httpEntity));
                        } else {
                            stringBuilder.append("## The payload is marked as 'not repeatable' and is the therefore not printed in debugging");
                        }
                    }
                    catch (Exception exception) {
                        stringBuilder.append("## Exception listing payload: " + exception.getClass().getName() + " -- " + exception.getMessage()).append("\r\n");
                        stringBuilder.append("## ").append(StackTraceHelper.getStackAsString((Throwable)exception));
                    }
                    return stringBuilder.toString();
                });
                object = httpClientManager.execute((HttpUriRequest)httpPost, httpClientResponseHandler);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        httpClientManager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    throw iOException2;
                }
            }
            httpClientManager.close();
            return (T)object;
        }
        finally {
            stopWatch.stop();
            if (iOException != null) {
                LOGGER.warn("Failed to transmit AS4 Message to '" + string + "' after " + stopWatch.getMillis() + " ms. Technical details: " + iOException.getClass().getName() + " - " + iOException.getMessage());
            } else {
                LOGGER.info("Finished transmitting AS4 Message to '" + string + "' after " + stopWatch.getMillis() + " ms");
            }
        }
    }

    @Nonnull
    protected static HttpEntity createDumpingHttpEntity(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nonnull HttpEntity httpEntity, @Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n, @Nonnull Wrapper<OutputStream> wrapper) throws IOException {
        if (iAS4OutgoingDumper == null) {
            return httpEntity;
        }
        final OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(EAS4MessageMode.REQUEST, null, null, string, httpHeaderMap, n);
        if (outputStream == null) {
            return httpEntity;
        }
        if (!httpEntity.isRepeatable()) {
            throw new IllegalStateException("If dumping of outgoing messages is enabled, a repeatable entity must be provided");
        }
        wrapper.set((Object)outputStream);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating dumping entity for the current request");
        }
        return new HttpEntityWrapper(httpEntity){

            public void writeTo(@Nonnull @WillNotClose OutputStream outputStream2) throws IOException {
                MultiOutputStream multiOutputStream = new MultiOutputStream(outputStream2, outputStream);
                super.writeTo((OutputStream)multiOutputStream);
                multiOutputStream.flush();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T sendGenericMessageWithRetries(@Nonnull String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnull HttpEntity httpEntity, @Nonnull String string2, @Nonnull HttpRetrySettings httpRetrySettings, @Nonnull HttpClientResponseHandler<? extends T> httpClientResponseHandler, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4RetryCallback iAS4RetryCallback) throws IOException {
        int n3;
        Duration duration;
        int n2;
        int n;
        Wrapper wrapper;
        IAS4OutgoingDumper iAS4OutgoingDumper2;
        block28: {
            T t;
            iAS4OutgoingDumper2 = iAS4OutgoingDumper != null ? iAS4OutgoingDumper : AS4DumpManager.getOutgoingDumper();
            wrapper = new Wrapper();
            IOException iOException = null;
            if (httpRetrySettings.isRetryEnabled()) {
                if (!httpEntity.isRepeatable()) {
                    throw new IllegalStateException("If retry is enabled, a repeatable entity must be provided");
                }
                n = httpRetrySettings.getMaxRetries();
                n2 = 1 + n;
                duration = httpRetrySettings.getDurationBeforeRetry();
                n3 = 0;
                break block28;
            }
            HttpEntity httpEntity3 = BasicHttpPoster.createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string2, httpHeaderMap, 0, (Wrapper<OutputStream>)wrapper);
            try {
                t = this.sendGenericMessage(string, httpHeaderMap, httpEntity3, httpClientResponseHandler);
            }
            catch (Throwable throwable) {
                try {
                    StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
                    throw throwable;
                }
                catch (IOException iOException3) {
                    iOException = iOException3;
                    throw iOException3;
                }
            }
            StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
            return t;
            finally {
                if (iAS4OutgoingDumper2 != null && wrapper.isSet()) {
                    try {
                        iAS4OutgoingDumper2.onEndRequest(EAS4MessageMode.REQUEST, null, null, string2, iOException);
                    }
                    catch (Exception exception) {
                        LOGGER.error("OutgoingDumper.onEndRequest failed. Dumper=" + String.valueOf(iAS4OutgoingDumper2) + "; MessageID=" + string2, (Throwable)exception);
                    }
                }
            }
        }
        while (n3 < n2) {
            if (n3 > 0) {
                LOGGER.info("Retry #" + n3 + "/" + n + " for sending message with ID '" + string2 + "'");
            }
            try {
                HttpEntity httpEntity2 = BasicHttpPoster.createDumpingHttpEntity(iAS4OutgoingDumper2, httpEntity, string2, httpHeaderMap, n3, (Wrapper<OutputStream>)wrapper);
                T t = this.sendGenericMessage(string, httpHeaderMap, httpEntity2, httpClientResponseHandler);
                return t;
            }
            catch (IOException iOException2) {
                if (n3 == n2 - 1) {
                    throw iOException2;
                }
                if (n3 > 1) {
                    duration = HttpRetrySettings.getIncreased(duration, httpRetrySettings.getRetryIncreaseFactor());
                }
                if (iAS4RetryCallback != null && iAS4RetryCallback.onBeforeRetry(string2, string, n3, n2, duration.toMillis(), iOException2).isBreak()) {
                    LOGGER.warn("Error sending message '" + string2 + "' to '" + string + ": " + iOException2.getClass().getSimpleName() + " - " + iOException2.getMessage() + " - retrying was explicitly stopped by the RetryCallback");
                    throw iOException2;
                }
                LOGGER.warn("Error sending message '" + string2 + "' to '" + string + "': " + iOException2.getClass().getSimpleName() + " - " + iOException2.getMessage() + " - waiting " + duration.toMillis() + " ms, than retrying");
                ThreadHelper.sleep((long)duration.toMillis());
                ++n3;
            }
        }
        throw new IllegalStateException("Should never be reached (after maximum of " + n2 + " tries)!");
        finally {
            StreamHelper.close((AutoCloseable)((AutoCloseable)wrapper.get()));
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("HttpClientFactory", (Object)this.m_aHttpClientFactory).append("HttpCustomizer", this.m_aHttpCustomizer).append("QuoteHttpHeaders", this.m_bQuoteHttpHeaders).getToString();
    }
}

