/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.message;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.marshaller.Ebms3MessagingMarshaller;
import com.helger.phase4.marshaller.Soap11EnvelopeMarshaller;
import com.helger.phase4.marshaller.Soap12EnvelopeMarshaller;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.message.EAS4MessageType;
import com.helger.phase4.model.message.IAS4Message;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.soap11.Soap11Body;
import com.helger.phase4.soap11.Soap11Envelope;
import com.helger.phase4.soap11.Soap11Header;
import com.helger.phase4.soap12.Soap12Body;
import com.helger.phase4.soap12.Soap12Envelope;
import com.helger.phase4.soap12.Soap12Header;
import com.helger.xml.XMLHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractAS4Message<IMPLTYPE extends AbstractAS4Message<IMPLTYPE>>
implements IAS4Message,
IGenericImplTrait<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS4Message.class);
    private static final QName QNAME_WSU_ID = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    private final ESoapVersion m_eSoapVersion;
    private final EAS4MessageType m_eMsgType;
    private final String m_sMessagingID;
    protected final Ebms3Messaging m_aMessaging = new Ebms3Messaging();
    public static final DateTimeFormatter DOMIBUS_XSD_DATE_TIME;

    public AbstractAS4Message(@Nonnull ESoapVersion eSoapVersion, @Nonnull EAS4MessageType eAS4MessageType) {
        this.m_eSoapVersion = (ESoapVersion)((Object)ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion"));
        this.m_eMsgType = (EAS4MessageType)((Object)ValueEnforcer.notNull((Object)((Object)eAS4MessageType), (String)"MessageType"));
        this.m_sMessagingID = MessageHelperMethods.createRandomMessagingID();
        this.m_aMessaging.getOtherAttributes().put(QNAME_WSU_ID, this.m_sMessagingID);
        this.setMustUnderstand(true);
    }

    @Override
    @Nonnull
    public final ESoapVersion getSoapVersion() {
        return this.m_eSoapVersion;
    }

    @Override
    @Nonnull
    public final EAS4MessageType getMessageType() {
        return this.m_eMsgType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getMessagingID() {
        return this.m_sMessagingID;
    }

    @Nonnull
    public final IMPLTYPE setMustUnderstand(boolean bl) {
        switch (this.m_eSoapVersion) {
            case SOAP_11: {
                this.m_aMessaging.setS11MustUnderstand(bl);
                break;
            }
            case SOAP_12: {
                this.m_aMessaging.setS12MustUnderstand(bl);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported SOAP version " + String.valueOf((Object)this.m_eSoapVersion));
            }
        }
        return (IMPLTYPE)((AbstractAS4Message)this.thisAsT());
    }

    @Override
    @Nonnull
    public final Document getAsSoapDocument(@Nullable Node node) {
        String string;
        OffsetDateTime offsetDateTime;
        Node node2;
        Object object;
        Node node3;
        Element element = new Ebms3MessagingMarshaller().getAsElement(this.m_aMessaging);
        if (element == null) {
            throw new IllegalStateException("Failed to write EBMS3 Messaging to XML");
        }
        if (AS4Configuration.isCompatibilityModeDomibus() && (node3 = (Element)XMLHelper.getChildElementIteratorNS((Node)element, (String)"http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/").next()) != null && (object = XMLHelper.getFirstChildElementOfName((Node)node3, (String)"http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", (String)"MessageInfo")) != null && (node2 = XMLHelper.getFirstChildElementOfName((Node)object, (String)"http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", (String)"Timestamp")) != null && (offsetDateTime = PDTWebDateHelper.getOffsetDateTimeFromXSD((String)(string = XMLHelper.getFirstChildText((Node)node2)))).get(ChronoField.MILLI_OF_SECOND) % 10 == 0) {
            String string2 = DOMIBUS_XSD_DATE_TIME.format(offsetDateTime);
            LOGGER.info("Changing MessageInfo/Timestamp from '" + string + "' to '" + string2 + "' for Domibus");
            XMLHelper.removeAllChildElements((Element)node2);
            node2.appendChild(node2.getOwnerDocument().createTextNode(string2));
        }
        node3 = node instanceof Document ? ((Document)node).getDocumentElement() : node;
        switch (this.m_eSoapVersion) {
            case SOAP_11: {
                object = new Soap11Envelope();
                ((Soap11Envelope)object).setHeader(new Soap11Header());
                ((Soap11Envelope)object).getHeader().addAny(element);
                ((Soap11Envelope)object).setBody(new Soap11Body());
                if (node3 != null) {
                    ((Soap11Envelope)object).getBody().addAny(node3);
                }
                if ((node2 = new Soap11EnvelopeMarshaller().getAsDocument(object)) == null) {
                    throw new IllegalStateException("Failed to serialize SOAP 1.1 document");
                }
                return node2;
            }
            case SOAP_12: {
                object = new Soap12Envelope();
                ((Soap12Envelope)object).setHeader(new Soap12Header());
                ((Soap12Envelope)object).getHeader().addAny(element);
                ((Soap12Envelope)object).setBody(new Soap12Body());
                if (node3 != null) {
                    ((Soap12Envelope)object).getBody().addAny(node3);
                }
                if ((node2 = new Soap12EnvelopeMarshaller().getAsDocument(object)) == null) {
                    throw new IllegalStateException("Failed to serialize SOAP 1.2 document");
                }
                return node2;
            }
        }
        throw new IllegalStateException("Unsupported SOAP version " + String.valueOf((Object)this.m_eSoapVersion));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SOAPVersion", (Enum)this.m_eSoapVersion).append("MsgType", (Enum)this.m_eMsgType).append("MessagingID", (Object)this.m_sMessagingID).append("Messaging", (Object)this.m_aMessaging).getToString();
    }

    static {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(Locale.getDefault(Locale.Category.FORMAT)).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
        DOMIBUS_XSD_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(dateTimeFormatter).toFormatter(Locale.getDefault(Locale.Category.FORMAT)).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    }
}

