/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.annotation.concurrent.Immutable;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.model.pmode.PModePayloadService;
import jakarta.annotation.Nonnull;

@Immutable
public final class PModePayloadServiceJsonConverter {
    private static final String COMPRESSION_MODE = "CompressionMode";

    private PModePayloadServiceJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModePayloadService pModePayloadService) {
        JsonObject jsonObject = new JsonObject();
        if (pModePayloadService.hasCompressionMode()) {
            jsonObject.add((Object)COMPRESSION_MODE, (Object)pModePayloadService.getCompressionModeID());
        }
        return jsonObject;
    }

    @Nonnull
    public static PModePayloadService convertToNative(@Nonnull IJsonObject iJsonObject) {
        String string = iJsonObject.getAsString((Object)COMPRESSION_MODE);
        EAS4CompressionMode eAS4CompressionMode = EAS4CompressionMode.getFromIDOrNull(string);
        if (string != null && eAS4CompressionMode == null) {
            throw new IllegalStateException("Invalid compression mode ID '" + string + "' provided!");
        }
        return new PModePayloadService(eAS4CompressionMode);
    }
}

