/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.util;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingBufferedOutputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FileIOError;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.util.AS4IOHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.slf4j.Logger;

public class AS4ResourceHelper
implements Closeable {
    private static final String TEMP_FILE_PREFIX = "phase4-res-";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4ResourceHelper.class);
    private static File s_aTempDir;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final AtomicBoolean m_aInClose = new AtomicBoolean(false);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<File> m_aTempFiles = new CommonsArrayList();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<Closeable> m_aCloseables = new CommonsArrayList();

    @Nullable
    public static File getTempDir() {
        return s_aTempDir;
    }

    public static void setTempDir(@Nullable File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Temporary directory '" + file.getAbsolutePath() + "' is not a directory");
        }
        s_aTempDir = file;
    }

    @Nonnull
    public File createTempFile() throws IOException {
        if (this.m_aInClose.get()) {
            throw new IllegalStateException("ResourceManager is already closing/closed!");
        }
        File file = s_aTempDir != null ? Files.createTempFile(s_aTempDir.toPath(), TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new FileAttribute[0]).toFile() : Files.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new FileAttribute[0]).toFile();
        this.m_aRWLock.writeLocked(() -> this.m_aTempFiles.add((Object)file));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AS4ResourceHelper.created temporary file '" + file.getAbsolutePath() + "'");
        }
        return file;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<File> getAllTempFiles() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aTempFiles.getClone());
    }

    public void addCloseable(@Nonnull Closeable closeable) {
        ValueEnforcer.notNull((Object)closeable, (String)"Closeable");
        if (this.m_aInClose.get()) {
            throw new IllegalStateException("AS4ResourceHelper is already closing/closed!");
        }
        this.m_aCloseables.add((Object)closeable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Closeable> getAllCloseables() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aCloseables.getClone());
    }

    @Override
    public void close() {
        if (!this.m_aInClose.getAndSet(true)) {
            Object object;
            Iterator iterator;
            ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.writeLockedGet(() -> {
                ICommonsList iCommonsList = (ICommonsList)this.m_aCloseables.getClone();
                this.m_aCloseables.clear();
                return iCommonsList;
            });
            if (iCommonsList.isNotEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing " + iCommonsList.size() + " phase4 stream handles");
                }
                iterator = iCommonsList.iterator();
                while (iterator.hasNext()) {
                    object = (Closeable)iterator.next();
                    StreamHelper.close((AutoCloseable)object);
                }
            }
            if ((iterator = (ICommonsList)this.m_aRWLock.writeLockedGet(() -> {
                ICommonsList iCommonsList = (ICommonsList)this.m_aTempFiles.getClone();
                this.m_aTempFiles.clear();
                return iCommonsList;
            })).isNotEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Deleting " + iterator.size() + " temporary phase4 files");
                }
                object = iterator.iterator();
                while (object.hasNext()) {
                    FileIOError fileIOError;
                    File file = (File)object.next();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Deleting temporary file '" + file.getAbsolutePath() + "'");
                    }
                    if (!(fileIOError = AS4IOHelper.getFileOperationManager().deleteFileIfExisting(file)).isFailure()) continue;
                    LOGGER.warn("  Failed to delete temporary phase4 file " + file.getAbsolutePath() + ": " + fileIOError.toString());
                }
            }
        }
    }

    @Nonnull
    public HttpEntity createRepeatableHttpEntity(@Nonnull HttpEntity httpEntity) throws IOException {
        ValueEnforcer.notNull((Object)httpEntity, (String)"SrcEntity");
        if (httpEntity.isRepeatable()) {
            return httpEntity;
        }
        File file = this.createTempFile();
        LOGGER.info("Converting " + String.valueOf(httpEntity) + " to a repeatable HTTP entity using file " + file.getAbsolutePath());
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream((File)file);){
            httpEntity.writeTo((OutputStream)nonBlockingBufferedOutputStream);
        }
        return new FileEntity(file, ContentType.parse((CharSequence)httpEntity.getContentType()), httpEntity.getContentEncoding());
    }
}

