/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.trait.IAddableByTrait;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.peppol.doctype.PredefinedDocumentTypeIdentifierManager;
import com.helger.peppolid.peppol.process.PredefinedProcessIdentifierManager;
import com.helger.phase4.CAS4Version;
import com.helger.phase4.dynamicdiscovery.AS4EndpointDetailProviderPeppol;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.marshaller.Ebms3SignalMessageMarshaller;
import com.helger.phase4.sender.EAS4UserMessageSendResult;
import com.helger.security.certificate.CertificateHelper;
import com.helger.security.certificate.ECertificateCheckResult;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;

@NotThreadSafe
public class Phase4PeppolSendingReport {
    private final OffsetDateTime m_aCurrentDateTimeUTC = PDTFactory.getCurrentOffsetDateTimeMillisOnlyUTC();
    private final String m_sSMLDNSZone;
    private Exception m_aSBDHParseException;
    private IParticipantIdentifier m_aSenderID;
    private IParticipantIdentifier m_aReceiverID;
    private IDocumentTypeIdentifier m_aDocTypeID;
    private IProcessIdentifier m_aProcessID;
    private String m_sCountryC1;
    private String m_sSenderPartyID;
    private String m_sTransportProfileID;
    private String m_sSBDHInstanceIdentifier;
    private String m_sC3EndpointURL;
    private X509Certificate m_aC3Cert;
    private String m_sC3CertSubjectCN;
    private String m_sC3CertSubjectO;
    private OffsetDateTime m_aC3CertCheckDT;
    private ECertificateCheckResult m_eC3CertCheckResult;
    private String m_sC3TechnicalContact;
    private String m_sAS4MessageID;
    private String m_sAS4ConversationID;
    private OffsetDateTime m_aAS4SendingDT;
    private EAS4UserMessageSendResult m_eAS4SendingResult;
    private Exception m_aAS4SendingException;
    private Ebms3SignalMessage m_aAS4ReceivedSignalMsg;
    private boolean m_bAS4ResponseError = false;
    private ICommonsList<Ebms3Error> m_aAS4ResponseErrors;
    private long m_nOverallDurationMillis = -1L;
    private boolean m_bSendingSuccess = false;
    private boolean m_bOverallSuccess = false;

    public Phase4PeppolSendingReport(@Nonnull ISMLInfo iSMLInfo) {
        this.m_sSMLDNSZone = iSMLInfo.getDNSZone();
        this.m_sTransportProfileID = AS4EndpointDetailProviderPeppol.DEFAULT_TRANSPORT_PROFILE.getID();
    }

    public boolean hasSBDHParseException() {
        return this.m_aSBDHParseException != null;
    }

    public void setSBDHParseException(@Nullable Exception exception) {
        this.m_aSBDHParseException = exception;
    }

    public boolean hasSenderID() {
        return this.m_aSenderID != null;
    }

    public void setSenderID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        this.m_aSenderID = iParticipantIdentifier;
    }

    public boolean hasReceiverID() {
        return this.m_aReceiverID != null;
    }

    public void setReceiverID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        this.m_aReceiverID = iParticipantIdentifier;
    }

    public boolean hasDocTypeID() {
        return this.m_aDocTypeID != null;
    }

    public void setDocTypeID(@Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        this.m_aDocTypeID = iDocumentTypeIdentifier;
    }

    public boolean hasProcessID() {
        return this.m_aProcessID != null;
    }

    public void setProcessID(@Nullable IProcessIdentifier iProcessIdentifier) {
        this.m_aProcessID = iProcessIdentifier;
    }

    public boolean hasCountryC1() {
        return StringHelper.isNotEmpty((String)this.m_sCountryC1);
    }

    public void setCountryC1(@Nullable String string) {
        this.m_sCountryC1 = string;
    }

    public boolean hasSenderPartyID() {
        return StringHelper.isNotEmpty((String)this.m_sSenderPartyID);
    }

    public void setSenderPartyID(@Nullable String string) {
        this.m_sSenderPartyID = string;
    }

    public boolean hasTransportProfileID() {
        return StringHelper.isNotEmpty((String)this.m_sTransportProfileID);
    }

    public void setTransportProfileID(@Nullable String string) {
        this.m_sTransportProfileID = string;
    }

    public boolean hasSBDHInstanceIdentifier() {
        return StringHelper.isNotEmpty((String)this.m_sSBDHInstanceIdentifier);
    }

    public void setSBDHInstanceIdentifier(@Nullable String string) {
        this.m_sSBDHInstanceIdentifier = string;
    }

    public boolean hasC3EndpointURL() {
        return StringHelper.isNotEmpty((String)this.m_sC3EndpointURL);
    }

    public void setC3EndpointURL(@Nullable String string) {
        this.m_sC3EndpointURL = string;
    }

    public boolean hasC3Cert() {
        return this.m_aC3Cert != null;
    }

    public boolean hasC3CertSubjectCN() {
        return StringHelper.isNotEmpty((String)this.m_sC3CertSubjectCN);
    }

    public boolean hasC3CertSubjectO() {
        return StringHelper.isNotEmpty((String)this.m_sC3CertSubjectO);
    }

    public void setC3Cert(@Nullable X509Certificate x509Certificate) {
        this.m_aC3Cert = x509Certificate;
        this.m_sC3CertSubjectCN = CertificateHelper.getSubjectCN((X509Certificate)x509Certificate);
        this.m_sC3CertSubjectO = CertificateHelper.getSubjectO((X509Certificate)x509Certificate);
    }

    public boolean hasC3CertCheckDT() {
        return this.m_aC3CertCheckDT != null;
    }

    public void setC3CertCheckDT(@Nullable OffsetDateTime offsetDateTime) {
        this.m_aC3CertCheckDT = offsetDateTime;
    }

    public boolean hasC3CertCheckResult() {
        return this.m_eC3CertCheckResult != null;
    }

    public void setC3CertCheckResult(@Nullable ECertificateCheckResult eCertificateCheckResult) {
        this.m_eC3CertCheckResult = eCertificateCheckResult;
    }

    public boolean hasC3TechnicalContact() {
        return StringHelper.isNotEmpty((String)this.m_sC3TechnicalContact);
    }

    public void setC3TechnicalContact(@Nullable String string) {
        this.m_sC3TechnicalContact = string;
    }

    public boolean hasAS4MessageID() {
        return StringHelper.isNotEmpty((String)this.m_sAS4MessageID);
    }

    public void setAS4MessageID(@Nullable String string) {
        this.m_sAS4MessageID = string;
    }

    public boolean hasAS4ConversationID() {
        return StringHelper.isNotEmpty((String)this.m_sAS4ConversationID);
    }

    public void setAS4ConversationID(@Nullable String string) {
        this.m_sAS4ConversationID = string;
    }

    public boolean hasAS4SendingDT() {
        return this.m_aAS4SendingDT != null;
    }

    public void setAS4SendingDT(@Nullable OffsetDateTime offsetDateTime) {
        this.m_aAS4SendingDT = offsetDateTime == null ? null : PDTFactory.getWithMillisOnly((OffsetDateTime)offsetDateTime);
    }

    public boolean hasAS4ReceivedSignalMsg() {
        return this.m_aAS4ReceivedSignalMsg != null;
    }

    public boolean hasAS4ResponseErrors() {
        return this.m_aAS4ResponseErrors != null && this.m_aAS4ResponseErrors.isNotEmpty();
    }

    public void setAS4ReceivedSignalMsg(@Nullable Ebms3SignalMessage ebms3SignalMessage) {
        this.m_aAS4ReceivedSignalMsg = ebms3SignalMessage;
        if (ebms3SignalMessage != null) {
            if (ebms3SignalMessage.hasErrorEntries()) {
                this.m_aAS4ResponseErrors = new CommonsArrayList((Collection)ebms3SignalMessage.getError());
                this.m_bAS4ResponseError = true;
            } else {
                this.m_bAS4ResponseError = false;
            }
        } else {
            this.m_aAS4ResponseErrors = null;
            this.m_bAS4ResponseError = false;
        }
    }

    public boolean hasAS4SendingResult() {
        return this.m_eAS4SendingResult != null;
    }

    public void setAS4SendingResult(@Nullable EAS4UserMessageSendResult eAS4UserMessageSendResult) {
        this.m_eAS4SendingResult = eAS4UserMessageSendResult;
    }

    public boolean hasAS4SendingException() {
        return this.m_aAS4SendingException != null;
    }

    public void setAS4SendingException(@Nullable Exception exception) {
        this.m_aAS4SendingException = exception;
    }

    public void setOverallDurationMillis(@Nonnegative long l) {
        this.m_nOverallDurationMillis = l;
    }

    public void setSendingSuccess(boolean bl) {
        this.m_bSendingSuccess = bl;
    }

    public void setOverallSuccess(boolean bl) {
        this.m_bOverallSuccess = bl;
    }

    @Nonnull
    public IJsonObject getAsJsonObject() {
        String string;
        Function<Exception, IJsonObject> function = exception -> (IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)"class", (Object)exception.getClass().getName())).add((Object)"message", (Object)exception.getMessage())).add((Object)"stackTrace", (Object)StackTraceHelper.getStackAsString((Throwable)exception));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)"currentDateTimeUTC", (Object)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)this.m_aCurrentDateTimeUTC));
        jsonObject.add((Object)"phase4Version", (Object)CAS4Version.BUILD_VERSION);
        jsonObject.add((Object)"smlDnsZone", (Object)this.m_sSMLDNSZone);
        if (this.hasSBDHParseException()) {
            jsonObject.add((Object)"sbdhParsingException", (IAddableByTrait)((IJson)function.apply(this.m_aSBDHParseException)));
        }
        if (this.hasSenderID()) {
            jsonObject.add((Object)"senderId", (Object)this.m_aSenderID.getURIEncoded());
        }
        if (this.hasReceiverID()) {
            jsonObject.add((Object)"receiverId", (Object)this.m_aReceiverID.getURIEncoded());
        }
        if (this.hasDocTypeID()) {
            string = this.m_aDocTypeID.getURIEncoded();
            jsonObject.add((Object)"docTypeId", (Object)string);
            jsonObject.add((Object)"docTypeIdInCodeList", PredefinedDocumentTypeIdentifierManager.containsDocumentTypeIdentifierWithID((String)string));
        }
        if (this.hasProcessID()) {
            string = this.m_aProcessID.getURIEncoded();
            jsonObject.add((Object)"processId", (Object)string);
            jsonObject.add((Object)"processIdInCodeList", PredefinedProcessIdentifierManager.containsProcessIdentifierWithID((String)string));
        }
        if (this.hasCountryC1()) {
            jsonObject.add((Object)"countryC1", (Object)this.m_sCountryC1);
        }
        if (this.hasSenderPartyID()) {
            jsonObject.add((Object)"senderPartyId", (Object)this.m_sSenderPartyID);
        }
        if (this.hasTransportProfileID()) {
            jsonObject.add((Object)"transportProfileId", (Object)this.m_sTransportProfileID);
        }
        if (this.hasSBDHInstanceIdentifier()) {
            jsonObject.add((Object)"sbdhInstanceIdentifier", (Object)this.m_sSBDHInstanceIdentifier);
        }
        if (this.hasC3EndpointURL()) {
            jsonObject.add((Object)"c3EndpointUrl", (Object)this.m_sC3EndpointURL);
        }
        if (this.hasC3Cert()) {
            jsonObject.add((Object)"c3Cert", (Object)CertificateHelper.getPEMEncodedCertificate((Certificate)this.m_aC3Cert));
        }
        if (this.hasC3CertSubjectCN()) {
            jsonObject.add((Object)"c3CertSubjectCN", (Object)this.m_sC3CertSubjectCN);
        }
        if (this.hasC3CertSubjectO()) {
            jsonObject.add((Object)"c3CertSubjectO", (Object)this.m_sC3CertSubjectO);
        }
        if (this.hasC3CertCheckDT()) {
            jsonObject.add((Object)"c3CertCheckDT", (Object)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)this.m_aC3CertCheckDT));
        }
        if (this.hasC3CertCheckResult()) {
            jsonObject.add((Object)"c3CertCheckResult", (Object)this.m_eC3CertCheckResult.name());
        }
        if (this.hasC3TechnicalContact()) {
            jsonObject.add((Object)"c3TechnicalContact", (Object)this.m_sC3TechnicalContact);
        }
        if (this.hasAS4MessageID()) {
            jsonObject.add((Object)"as4MessageId", (Object)this.m_sAS4MessageID);
        }
        if (this.hasAS4ConversationID()) {
            jsonObject.add((Object)"as4ConversationId", (Object)this.m_sAS4ConversationID);
        }
        if (this.hasAS4SendingDT()) {
            jsonObject.add((Object)"as4SendingDateTime", (Object)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)this.m_aAS4SendingDT));
        }
        if (this.hasAS4SendingResult()) {
            jsonObject.add((Object)"sendingResult", (Object)this.m_eAS4SendingResult.name());
        }
        if (this.hasAS4SendingException()) {
            jsonObject.add((Object)"sendingException", (IAddableByTrait)((IJson)function.apply(this.m_aAS4SendingException)));
        }
        if (this.hasAS4ReceivedSignalMsg()) {
            jsonObject.add((Object)"as4ReceivedSignalMsg", (Object)new Ebms3SignalMessageMarshaller().getAsString((Object)this.m_aAS4ReceivedSignalMsg));
        }
        jsonObject.add((Object)"as4ResponseError", this.m_bAS4ResponseError);
        if (this.hasAS4ResponseErrors()) {
            string = new JsonArray();
            for (Ebms3Error ebms3Error : this.m_aAS4ResponseErrors) {
                JsonObject jsonObject2 = new JsonObject();
                if (ebms3Error.getDescription() != null) {
                    jsonObject2.add((Object)"description", (Object)ebms3Error.getDescriptionValue());
                }
                if (ebms3Error.getErrorDetail() != null) {
                    jsonObject2.add((Object)"errorDetails", (Object)ebms3Error.getErrorDetail());
                }
                if (ebms3Error.getCategory() != null) {
                    jsonObject2.add((Object)"category", (Object)ebms3Error.getCategory());
                }
                if (ebms3Error.getRefToMessageInError() != null) {
                    jsonObject2.add((Object)"refToMessageInError", (Object)ebms3Error.getRefToMessageInError());
                }
                if (ebms3Error.getErrorCode() != null) {
                    jsonObject2.add((Object)"errorCode", (Object)ebms3Error.getErrorCode());
                }
                if (ebms3Error.getOrigin() != null) {
                    jsonObject2.add((Object)"origin", (Object)ebms3Error.getOrigin());
                }
                if (ebms3Error.getSeverity() != null) {
                    jsonObject2.add((Object)"severity", (Object)ebms3Error.getSeverity());
                }
                if (ebms3Error.getShortDescription() != null) {
                    jsonObject2.add((Object)"shortDescription", (Object)ebms3Error.getShortDescription());
                }
                string.add((IAddableByTrait)jsonObject2);
            }
            jsonObject.add((Object)"as4ResponseErrors", (IAddableByTrait)string);
        }
        jsonObject.add((Object)"overallDurationMillis", this.m_nOverallDurationMillis);
        jsonObject.add((Object)"sendingSuccess", this.m_bSendingSuccess);
        jsonObject.add((Object)"overallSuccess", this.m_bOverallSuccess);
        return jsonObject;
    }

    @Nonnull
    public String getAsJsonString() {
        return this.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS_FORMATTED);
    }

    @Nonnull
    public String getAsJsonString(@Nonnull IJsonWriterSettings iJsonWriterSettings) {
        return this.getAsJsonObject().getAsJsonString(iJsonWriterSettings);
    }

    @Nonnull
    public IMicroElement getAsMicroElement(@Nullable String string, @Nonnull @Nonempty String string3) {
        String string4;
        BiFunction<Exception, String, IMicroElement> biFunction = (exception, string2) -> {
            MicroElement microElement = new MicroElement(string, string2);
            microElement.addElementNS(string, "Class").addText((CharSequence)exception.getClass().getName());
            microElement.addElementNS(string, "Message").addText((CharSequence)exception.getMessage());
            microElement.addElementNS(string, "StackTrace").addText((CharSequence)StackTraceHelper.getStackAsString((Throwable)exception));
            return microElement;
        };
        MicroElement microElement = new MicroElement(string, string3);
        microElement.addElementNS(string, "CurrentDateTimeUTC").addText((CharSequence)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)this.m_aCurrentDateTimeUTC));
        microElement.addElementNS(string, "phase4Version").addText((CharSequence)CAS4Version.BUILD_VERSION);
        microElement.addElementNS(string, "SMLDNSZone").addText((CharSequence)this.m_sSMLDNSZone);
        if (this.hasSBDHParseException()) {
            microElement.addChild((IMicroNode)biFunction.apply(this.m_aSBDHParseException, "SBDHParsingException"));
        }
        if (this.hasSenderID()) {
            microElement.addElementNS(string, "SenderID").addText((CharSequence)this.m_aSenderID.getURIEncoded());
        }
        if (this.hasReceiverID()) {
            microElement.addElementNS(string, "ReceiverID").addText((CharSequence)this.m_aReceiverID.getURIEncoded());
        }
        if (this.hasDocTypeID()) {
            string4 = this.m_aDocTypeID.getURIEncoded();
            ((IMicroElement)microElement.addElementNS(string, "DocTypeID").setAttribute("inCodeList", PredefinedDocumentTypeIdentifierManager.containsDocumentTypeIdentifierWithID((String)string4))).addText((CharSequence)string4);
        }
        if (this.hasProcessID()) {
            string4 = this.m_aProcessID.getURIEncoded();
            ((IMicroElement)microElement.addElementNS(string, "ProcessID").setAttribute("inCodeList", PredefinedProcessIdentifierManager.containsProcessIdentifierWithID((String)string4))).addText((CharSequence)string4);
        }
        if (this.hasCountryC1()) {
            microElement.addElementNS(string, "CountryC1").addText((CharSequence)this.m_sCountryC1);
        }
        if (this.hasSenderPartyID()) {
            microElement.addElementNS(string, "SenderPartyID").addText((CharSequence)this.m_sSenderPartyID);
        }
        if (this.hasTransportProfileID()) {
            microElement.addElementNS(string, "TransportProfileID").addText((CharSequence)this.m_sTransportProfileID);
        }
        if (this.hasSBDHInstanceIdentifier()) {
            microElement.addElementNS(string, "SBDHInstanceIdentifier").addText((CharSequence)this.m_sSBDHInstanceIdentifier);
        }
        if (this.hasC3EndpointURL()) {
            microElement.addElementNS(string, "C3EndpointUrl").addText((CharSequence)this.m_sC3EndpointURL);
        }
        if (this.hasC3Cert()) {
            microElement.addElementNS(string, "C3Cert").addText((CharSequence)CertificateHelper.getPEMEncodedCertificate((Certificate)this.m_aC3Cert));
        }
        if (this.hasC3CertSubjectCN()) {
            microElement.addElementNS(string, "C3CertSubjectCN").addText((CharSequence)this.m_sC3CertSubjectCN);
        }
        if (this.hasC3CertSubjectO()) {
            microElement.addElementNS(string, "C3CertSubjectO").addText((CharSequence)this.m_sC3CertSubjectO);
        }
        if (this.hasC3CertCheckDT()) {
            microElement.addElementNS(string, "C3CertCheckDT").addText((CharSequence)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)this.m_aC3CertCheckDT));
        }
        if (this.hasC3CertCheckResult()) {
            microElement.addElementNS(string, "C3CertCheckResult").addText((CharSequence)this.m_eC3CertCheckResult.name());
        }
        if (this.hasC3TechnicalContact()) {
            microElement.addElementNS(string, "C3TechnicalContact").addText((CharSequence)this.m_sC3TechnicalContact);
        }
        if (this.hasAS4MessageID()) {
            microElement.addElementNS(string, "AS4MessageId").addText((CharSequence)this.m_sAS4MessageID);
        }
        if (this.hasAS4ConversationID()) {
            microElement.addElementNS(string, "AS4ConversationId").addText((CharSequence)this.m_sAS4ConversationID);
        }
        if (this.hasAS4SendingDT()) {
            microElement.addElementNS(string, "AS4SendingDateTime").addText((CharSequence)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)this.m_aAS4SendingDT));
        }
        if (this.hasAS4SendingResult()) {
            microElement.addElementNS(string, "AS4SendingResult").addText((CharSequence)this.m_eAS4SendingResult.name());
        }
        if (this.hasAS4SendingException()) {
            microElement.addChild((IMicroNode)biFunction.apply(this.m_aAS4SendingException, "AS4SendingException"));
        }
        if (this.hasAS4ReceivedSignalMsg()) {
            microElement.addElementNS(string, "AS4ReceivedSignalMsg").addChild((IMicroNode)new Ebms3SignalMessageMarshaller().getAsMicroElement((Object)this.m_aAS4ReceivedSignalMsg));
        }
        microElement.addElementNS(string, "AS4ResponseError").addText(this.m_bAS4ResponseError);
        if (this.hasAS4ResponseErrors()) {
            string4 = microElement.addElementNS(string, "AS4ResponseErrors");
            for (Ebms3Error ebms3Error : this.m_aAS4ResponseErrors) {
                IMicroElement iMicroElement = string4.addElementNS(string, "Item");
                if (ebms3Error.getDescription() != null) {
                    iMicroElement.addElementNS(string, "Description").addText((CharSequence)ebms3Error.getDescriptionValue());
                }
                if (ebms3Error.getErrorDetail() != null) {
                    iMicroElement.addElementNS(string, "ErrorDetails").addText((CharSequence)ebms3Error.getErrorDetail());
                }
                if (ebms3Error.getCategory() != null) {
                    iMicroElement.addElementNS(string, "Category").addText((CharSequence)ebms3Error.getCategory());
                }
                if (ebms3Error.getRefToMessageInError() != null) {
                    iMicroElement.addElementNS(string, "RefToMessageInError").addText((CharSequence)ebms3Error.getRefToMessageInError());
                }
                if (ebms3Error.getErrorCode() != null) {
                    iMicroElement.addElementNS(string, "ErrorCode").addText((CharSequence)ebms3Error.getErrorCode());
                }
                if (ebms3Error.getOrigin() != null) {
                    iMicroElement.addElementNS(string, "Origin").addText((CharSequence)ebms3Error.getOrigin());
                }
                if (ebms3Error.getSeverity() != null) {
                    iMicroElement.addElementNS(string, "Severity").addText((CharSequence)ebms3Error.getSeverity());
                }
                if (ebms3Error.getShortDescription() == null) continue;
                iMicroElement.addElementNS(string, "ShortDescription").addText((CharSequence)ebms3Error.getShortDescription());
            }
        }
        microElement.addElementNS(string, "OverallDurationMillis").addText(this.m_nOverallDurationMillis);
        microElement.addElementNS(string, "SendingSuccess").addText(this.m_bSendingSuccess);
        microElement.addElementNS(string, "OverallSuccess").addText(this.m_bOverallSuccess);
        return microElement;
    }

    @Nonnull
    public String getAsXMLString() {
        return this.getAsXMLString(null, (IXMLWriterSettings)new XMLWriterSettings().setIndent(EXMLSerializeIndent.INDENT_AND_ALIGN));
    }

    @Nonnull
    public String getAsXMLString(@Nullable String string, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        return MicroWriter.getNodeAsString((IMicroNode)this.getAsMicroElement(string, "PeppolSendingReport"), (IXMLWriterSettings)iXMLWriterSettings);
    }
}

