/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.executorset;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.phive.api.execute.IValidationExecutorCacheSupport;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetMutable;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.api.source.IValidationSource;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Iterator;

@NotThreadSafe
public class ValidationExecutorSet<SOURCETYPE extends IValidationSource>
implements IValidationExecutorSetMutable<SOURCETYPE> {
    private final DVRCoordinate m_aVESID;
    private final String m_sDisplayName;
    private final ICommonsList<IValidationExecutor<SOURCETYPE>> m_aList = new CommonsArrayList();
    private final IValidationExecutorSetStatus m_aStatus;

    public ValidationExecutorSet(@Nonnull DVRCoordinate dVRCoordinate, @Nonnull @Nonempty String string, @Nonnull IValidationExecutorSetStatus iValidationExecutorSetStatus) {
        ValueEnforcer.notNull((Object)dVRCoordinate, (String)"ID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
        ValueEnforcer.notNull((Object)iValidationExecutorSetStatus, (String)"Status");
        this.m_aVESID = dVRCoordinate;
        this.m_sDisplayName = string;
        this.m_aStatus = iValidationExecutorSetStatus;
    }

    @Nonnull
    public final DVRCoordinate getID() {
        return this.m_aVESID;
    }

    @Nonnull
    @Nonempty
    public final String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public final Iterator<IValidationExecutor<SOURCETYPE>> iterator() {
        return this.m_aList.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<IValidationExecutor<SOURCETYPE>> executors() {
        return this.m_aList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IValidationExecutor<SOURCETYPE>> getAllExecutors() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Override
    @Nonnull
    public final IValidationExecutorSetStatus getStatus() {
        return this.m_aStatus;
    }

    @Override
    @Nonnull
    public ValidationExecutorSet<SOURCETYPE> addExecutor(@Nonnull IValidationExecutor<SOURCETYPE> iValidationExecutor) {
        ValueEnforcer.notNull(iValidationExecutor, (String)"Executor");
        this.m_aList.add(iValidationExecutor);
        return this;
    }

    @Override
    public void setValidationExecutorDoCache(boolean bl) {
        for (IValidationExecutor iValidationExecutor : this.m_aList) {
            if (!(iValidationExecutor instanceof IValidationExecutorCacheSupport)) continue;
            ((IValidationExecutorCacheSupport)((Object)iValidationExecutor)).setCacheArtefact(bl);
        }
    }

    @Override
    @Nonnull
    public EChange removeAllExecutors() {
        return this.m_aList.removeAll();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationExecutorSet validationExecutorSet = (ValidationExecutorSet)object;
        return this.m_aVESID.equals((Object)validationExecutorSet.m_aVESID) && this.m_sDisplayName.equals(validationExecutorSet.m_sDisplayName) && this.m_aList.equals(validationExecutorSet.m_aList);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aVESID).append((Object)this.m_sDisplayName).append(this.m_aList).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_aVESID).append("DisplayName", (Object)this.m_sDisplayName).append("List", this.m_aList).append("Status", (Object)this.m_aStatus).getToString();
    }

    @Nonnull
    @SafeVarargs
    public static <ST extends IValidationSource> ValidationExecutorSet<ST> create(@Nonnull DVRCoordinate dVRCoordinate, @Nonnull @Nonempty String string, @Nonnull IValidationExecutorSetStatus iValidationExecutorSetStatus, IValidationExecutor<ST> ... iValidationExecutorArray) {
        ValueEnforcer.notNull((Object)dVRCoordinate, (String)"ID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
        ValueEnforcer.noNullValue((Object[])iValidationExecutorArray, (String)"ValidationExecutors");
        ValidationExecutorSet validationExecutorSet = new ValidationExecutorSet(dVRCoordinate, string, iValidationExecutorSetStatus);
        for (IValidationExecutor<ST> iValidationExecutor : iValidationExecutorArray) {
            validationExecutorSet.addExecutor((IValidationExecutor)iValidationExecutor);
        }
        return validationExecutorSet;
    }

    @Nonnull
    public static <ST extends IValidationSource> ValidationExecutorSet<ST> create(@Nonnull DVRCoordinate dVRCoordinate, @Nonnull @Nonempty String string, @Nonnull IValidationExecutorSetStatus iValidationExecutorSetStatus, @Nonnull Collection<? extends IValidationExecutor<ST>> collection) {
        ValueEnforcer.notNull((Object)dVRCoordinate, (String)"ID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
        ValueEnforcer.noNullValue(collection, (String)"ValidationExecutors");
        ValidationExecutorSet validationExecutorSet = new ValidationExecutorSet(dVRCoordinate, string, iValidationExecutorSetStatus);
        for (IValidationExecutor<ST> iValidationExecutor : collection) {
            validationExecutorSet.addExecutor((IValidationExecutor)iValidationExecutor);
        }
        return validationExecutorSet;
    }

    @Nonnull
    @SafeVarargs
    public static <ST extends IValidationSource> ValidationExecutorSet<ST> createDerived(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull DVRCoordinate dVRCoordinate, @Nonnull @Nonempty String string, @Nonnull IValidationExecutorSetStatus iValidationExecutorSetStatus, IValidationExecutor<ST> ... iValidationExecutorArray) {
        ValueEnforcer.notNull(iValidationExecutorSet, (String)"BaseVES");
        ValueEnforcer.notNull((Object)dVRCoordinate, (String)"ID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
        ValueEnforcer.notEmptyNoNullValue((Object[])iValidationExecutorArray, (String)"ValidationExecutors");
        ValidationExecutorSet validationExecutorSet = new ValidationExecutorSet(dVRCoordinate, string, iValidationExecutorSetStatus);
        IValidationExecutor<ST>[] iValidationExecutorArray2 = iValidationExecutorSet.iterator();
        while (iValidationExecutorArray2.hasNext()) {
            IValidationExecutor iValidationExecutor = (IValidationExecutor)iValidationExecutorArray2.next();
            validationExecutorSet.addExecutor(iValidationExecutor);
        }
        for (IValidationExecutor<ST> iValidationExecutor : iValidationExecutorArray) {
            validationExecutorSet.addExecutor((IValidationExecutor)iValidationExecutor);
        }
        return validationExecutorSet;
    }
}

