/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.executorset.status;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.helper.PDTFactory;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.phive.api.executorset.status.EValidationExecutorStatusType;
import com.helger.phive.api.executorset.status.ValidationExecutorSetStatusHistoryItem;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;

public interface IValidationExecutorSetStatus {
    @Nonnull
    public OffsetDateTime getStatusLastModification();

    @Nonnull
    public EValidationExecutorStatusType getType();

    default public boolean isDeprecated() {
        return this.getType().isDeprecated();
    }

    default public boolean hasValidFrom() {
        return this.getValidFrom() != null;
    }

    @Nullable
    public OffsetDateTime getValidFrom();

    default public boolean hasValidTo() {
        return this.getValidTo() != null;
    }

    @Nullable
    public OffsetDateTime getValidTo();

    default public boolean isValidPerNow() {
        return this.isValidPer(PDTFactory.getCurrentOffsetDateTime());
    }

    default public boolean isValidPer(@Nonnull OffsetDateTime offsetDateTime) {
        if (this.hasValidFrom() && offsetDateTime.isBefore(this.getValidFrom())) {
            return false;
        }
        return !this.hasValidTo() || !offsetDateTime.isAfter(this.getValidTo());
    }

    default public boolean hasDeprecationReason() {
        return StringHelper.isNotEmpty((String)this.getDeprecationReason());
    }

    @Nullable
    public String getDeprecationReason();

    default public boolean hasReplacementVESID() {
        return this.getReplacementVESID() != null;
    }

    @Nullable
    public DVRCoordinate getReplacementVESID();

    @Nonnull
    @Nonempty
    @ReturnsMutableObject
    public ICommonsList<ValidationExecutorSetStatusHistoryItem> historyItems();

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<ValidationExecutorSetStatusHistoryItem> getAllHistoryItems();
}

